/*
 * Decompiled with CFR 0.152.
 */
package net.onelitefeather.attollo.service;

import com.github.zafarkhaja.semver.Version;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.onelitefeather.attollo.Attollo;
import net.onelitefeather.attollo.service.UpdateService;
import net.onelitefeather.attollo.utils.LoggerAudience;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpdateServiceImpl
implements UpdateService {
    private static final String UPDATE_PERMISSION = "attollo.update";
    private static final String NOTIFY_PLAYER_UPDATE_MESSAGE = "<yellow><download_url>Your version (<local_version>) is older than our latest published version (<remote_version>).\nPlease update as soon as possible to get continued support. Or click me to get on the download page!".trim();
    private static final String NOTIFY_CONSOLE_UPDATE_MESSAGE = "<yellow>Your version (<local_version>) is older than our latest published version (<remote_version>).\nPlease update as soon as possible to get continued support. Or use this link <download_url>.\n".trim();
    private static final String DOWNLOAD_URL = "https://hangar.papermc.io/OneLiteFeather/Attollo/versions/%s";
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateServiceImpl.class);
    private static final long UPDATE_CHECK_INTERVAL_TICKS = Long.getLong("ATTOLLO_UPDATE_SERVICE_SCHEDULE", 216000L);
    private static final HttpRequest LATEST_RELEASE_VERSION_REQUEST = HttpRequest.newBuilder().uri(URI.create("https://hangar.papermc.io/api/v1/projects/Attollo/latestrelease")).GET().build();
    private final Attollo plugin;
    private final LoggerAudience loggerAudience;
    private final Version localVersion;
    private BukkitTask scheduler;
    private Version remoteVersion;

    public UpdateServiceImpl(Attollo plugin, LoggerAudience loggerAudience) {
        this.plugin = plugin;
        this.localVersion = Version.parse(plugin.getPluginMeta().getVersion());
        this.loggerAudience = loggerAudience;
    }

    @Override
    public void startUpdateCheck() {
        this.scheduler = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, (Runnable)this, 0L, UPDATE_CHECK_INTERVAL_TICKS);
    }

    @Override
    public void notifyAudience(Audience audience) {
        if (this.remoteVersion == null || !this.remoteVersion.isHigherThan(this.localVersion)) {
            return;
        }
        if (audience instanceof LoggerAudience) {
            TagResolver[] tagResolverArray = new TagResolver[3];
            tagResolverArray[0] = Placeholder.component((String)"local_version", (ComponentLike)Component.text((String)this.localVersion.toString()));
            tagResolverArray[1] = Placeholder.component((String)"remote_version", (ComponentLike)Component.text((String)this.remoteVersion.toString()));
            tagResolverArray[2] = Placeholder.component((String)"download_url", (ComponentLike)Component.text((String)String.format(this.remoteVersion.toString(), new Object[0])));
            audience.sendMessage(MiniMessage.miniMessage().deserialize(NOTIFY_CONSOLE_UPDATE_MESSAGE, tagResolverArray));
            return;
        }
        TagResolver[] tagResolverArray = new TagResolver[3];
        tagResolverArray[0] = Placeholder.component((String)"local_version", (ComponentLike)Component.text((String)this.localVersion.toString()));
        tagResolverArray[1] = Placeholder.component((String)"remote_version", (ComponentLike)Component.text((String)this.remoteVersion.toString()));
        tagResolverArray[2] = Placeholder.component((String)"download_url", (ComponentLike)Component.text((String)String.format(this.remoteVersion.toString(), new Object[0])));
        audience.sendMessage(MiniMessage.miniMessage().deserialize(NOTIFY_PLAYER_UPDATE_MESSAGE, tagResolverArray).clickEvent(ClickEvent.openUrl((String)DOWNLOAD_URL.formatted(this.remoteVersion.toString()))));
    }

    @Override
    public void shutdown() {
        if (this.scheduler != null) {
            this.scheduler.cancel();
        }
    }

    @Override
    public String getPermission() {
        return UPDATE_PERMISSION;
    }

    @Override
    public void run() {
        this.remoteVersion = this.getNewerVersion();
        if (this.remoteVersion == null) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.isOp() && !player.hasPermission(UPDATE_PERMISSION)) continue;
            this.notifyAudience((Audience)player);
        }
        this.notifyAudience(this.loggerAudience);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Version getNewerVersion() {
        try (HttpClient hangarClient = HttpClient.newBuilder().build();){
            HttpResponse<String> httpResponse = hangarClient.send(LATEST_RELEASE_VERSION_REQUEST, HttpResponse.BodyHandlers.ofString());
            if (httpResponse.statusCode() != 200) {
                Version version = null;
                return version;
            }
            Version remoteVersion = Version.parse(httpResponse.body());
            if (!remoteVersion.isHigherThan(this.localVersion)) return null;
            Version version = remoteVersion;
            return version;
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Something went wrong to check updates", (Throwable)e);
        }
        return null;
    }
}

