/*
 * Decompiled with CFR 0.152.
 */
package com.Pink_Cats.createschematicchecker.FancyConfig;

import com.Pink_Cats.createschematicchecker.FancyConfig.SimpleTomlEditor;
import com.Pink_Cats.createschematicchecker.core.BlueEngine.StrFunc;
import com.Pink_Cats.createschematicchecker.lang.CSCLanguage;
import com.Pink_Cats.createschematicchecker.lang.Message;

public class ConfigValue {
    static SimpleTomlEditor tomlEditor = new SimpleTomlEditor("config/CSC/config.toml");

    public ConfigString define(String key, String defaultValue) {
        Object ConfigOperateResult = tomlEditor.ConfigValue_IO(key, defaultValue);
        if (ConfigOperateResult != null) {
            return new ConfigString(key, (String)ConfigOperateResult);
        }
        return new ConfigString(key, defaultValue);
    }

    public ConfigBoolean define(String key, boolean defaultValue) {
        Object configOperateResult = tomlEditor.ConfigValue_IO(key, defaultValue);
        if (configOperateResult instanceof Boolean) {
            return new ConfigBoolean(key, (Boolean)configOperateResult);
        }
        if (configOperateResult instanceof String) {
            String strValue = (String)configOperateResult;
            if ("true".equals(strValue = StrFunc.NoAir(strValue))) {
                return new ConfigBoolean(key, true);
            }
            return new ConfigBoolean(key, false);
        }
        return new ConfigBoolean(key, defaultValue);
    }

    public ConfigInt define(String key, int defaultValue) {
        Object configOperateResult = tomlEditor.ConfigValue_IO(key, defaultValue);
        if (configOperateResult instanceof Integer) {
            return new ConfigInt(key, (Integer)configOperateResult);
        }
        if (configOperateResult instanceof String) {
            String strValue = (String)configOperateResult;
            strValue = strValue.trim();
            try {
                int intValue = Integer.parseInt(strValue);
                return new ConfigInt(key, intValue);
            }
            catch (NumberFormatException e) {
                Message.FW("Invalid integer format for key: " + key + " value: '" + strValue + "'");
                return new ConfigInt(key, defaultValue);
            }
        }
        return new ConfigInt(key, defaultValue);
    }

    public ConfigStringArray define(String key, String[] defaultValue) {
        Object configOperateResult = tomlEditor.ConfigValue_IO(key, defaultValue);
        if (configOperateResult instanceof String[]) {
            return new ConfigStringArray(key, (String[])configOperateResult);
        }
        if (configOperateResult instanceof String) {
            String strValue = (String)configOperateResult;
            String[] strArray = ConfigValue.processArrayString(strValue);
            return new ConfigStringArray(key, strArray);
        }
        return new ConfigStringArray(key, defaultValue);
    }

    public static String[] processArrayString(String strValue) {
        strValue = strValue.replaceAll("[\\[\\]\" {}XYZ:]", "");
        strValue = StrFunc.NoAir(strValue);
        return strValue.split(",");
    }

    public static String[] ChainSplit(String strValue) {
        strValue = strValue.replaceAll("[\\[\\]\" ]", "");
        strValue = StrFunc.NoAir(strValue);
        return strValue.split("\\.");
    }

    public static String[] KnifeSplit(String strValue) {
        strValue = strValue.replaceAll("[\\[\\]\" ]", "");
        strValue = StrFunc.NoAir(strValue);
        return strValue.split("\\$");
    }

    public static class ConfigString {
        private final String key;
        private String value;

        public ConfigString(String key, String defaultValue) {
            this.key = key;
            this.value = defaultValue;
        }

        public ConfigString comment(String comment) {
            tomlEditor.insertCommentAboveKey(this.key, CSCLanguage.translateDirect(comment));
            return this;
        }

        public String getDefaultValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public static ConfigString fromJavaString(String key, String value) {
            return new ConfigString(key, value);
        }

        public void reload() {
            Object configOperateResult = tomlEditor.ConfigValue_IO(this.key, this.value);
            if (configOperateResult != null) {
                this.value = (String)configOperateResult;
            }
        }
    }

    public static class ConfigBoolean {
        private final String key;
        private boolean value;

        public ConfigBoolean(String key, boolean defaultValue) {
            this.key = key;
            this.value = defaultValue;
        }

        public ConfigBoolean comment(String comment) {
            tomlEditor.insertCommentAboveKey(this.key, CSCLanguage.translateDirect(comment));
            return this;
        }

        public boolean getDefaultValue() {
            return this.value;
        }

        public void setValue(boolean value) {
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void reload() {
            Object configOperateResult = tomlEditor.ConfigValue_IO(this.key, this.value);
            if (configOperateResult instanceof Boolean) {
                this.value = (Boolean)configOperateResult;
            } else if (configOperateResult instanceof String) {
                String strValue = (String)configOperateResult;
                strValue = StrFunc.NoAir(strValue);
                this.value = "true".equals(strValue);
            } else {
                this.value = false;
            }
        }

        public static ConfigBoolean fromJavaBoolean(String key, boolean value) {
            return new ConfigBoolean(key, value);
        }
    }

    public static class ConfigInt {
        private final String key;
        private int value;

        public ConfigInt(String key, int defaultValue) {
            this.key = key;
            this.value = defaultValue;
        }

        public ConfigInt comment(String comment) {
            tomlEditor.insertCommentAboveKey(this.key, CSCLanguage.translateDirect(comment));
            return this;
        }

        public int getDefaultValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public static ConfigInt fromJavaInt(String key, int value) {
            return new ConfigInt(key, value);
        }

        public void reload() {
            Object configOperateResult = tomlEditor.ConfigValue_IO(this.key, this.value);
            if (configOperateResult instanceof Integer) {
                this.value = (Integer)configOperateResult;
            } else if (configOperateResult instanceof String) {
                String strValue = (String)configOperateResult;
                strValue = strValue.trim();
                try {
                    int intValue = Integer.parseInt(strValue);
                    this.value = new ConfigInt(this.key, intValue).getDefaultValue();
                }
                catch (NumberFormatException e) {
                    Message.FW("Invalid integer format for key: " + this.key + " value: '" + strValue + "'");
                    this.value = 0;
                }
            } else {
                this.value = 0;
            }
        }
    }

    public static class ConfigStringArray {
        private final String key;
        private String[] value;

        public ConfigStringArray(String key, String[] defaultValue) {
            this.key = key;
            this.value = defaultValue;
        }

        public ConfigStringArray comment(String comment) {
            tomlEditor.insertCommentAboveKey(this.key, CSCLanguage.translateDirect(comment));
            return this;
        }

        public String[] getDefaultValue() {
            return this.value;
        }

        public void setValue(String[] value) {
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public static ConfigStringArray fromJavaStringArray(String key, String[] value) {
            return new ConfigStringArray(key, value);
        }

        public void reload() {
            Object configOperateResult = tomlEditor.ConfigValue_IO(this.key, this.value);
            if (configOperateResult instanceof String[]) {
                this.value = (String[])configOperateResult;
            } else if (configOperateResult instanceof String) {
                String strValue = (String)configOperateResult;
                this.value = ConfigValue.processArrayString(strValue);
            } else {
                this.value = new String[0];
            }
        }
    }
}

