/*
 * Decompiled with CFR 0.152.
 */
package com.Pink_Cats.createschematicchecker.mixin;

import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.FlowSource;
import com.simibubi.create.content.fluids.OpenEndedPipe;
import com.simibubi.create.content.fluids.pipes.VanillaFluidTargets;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.mixin.accessor.FlowingFluidAccessor;
import net.createmod.catnip.math.BlockFace;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={OpenEndedPipe.class}, remap=false)
public class OpenEndedPipeMixin
extends FlowSource {
    @Unique
    private static final BooleanProperty createSchematicChecker$LAVALOGGED = BooleanProperty.create((String)"lavalogged");
    @Shadow
    private Level world;
    @Shadow
    private BlockPos outputPos;
    @Shadow
    private BlockPos pos;

    public OpenEndedPipeMixin(BlockFace location) {
        super(location);
    }

    @Inject(method={"removeFluidFromSpace"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void removeFluidFromSpace(boolean simulate, CallbackInfoReturnable<FluidStack> cir) {
        FlowingFluidAccessor flowing;
        FluidState potentiallyFilled;
        FluidStack empty = FluidStack.EMPTY;
        if (this.world == null) {
            cir.setReturnValue((Object)empty);
            cir.cancel();
            return;
        }
        if (!this.world.isLoaded(this.outputPos)) {
            cir.setReturnValue((Object)empty);
            cir.cancel();
            return;
        }
        BlockState state = this.world.getBlockState(this.outputPos);
        FluidState fluidState = state.getFluidState();
        boolean waterlog = state.hasProperty((Property)BlockStateProperties.WATERLOGGED);
        boolean lavalog = state.hasProperty((Property)createSchematicChecker$LAVALOGGED);
        FluidStack drainBlock = VanillaFluidTargets.drainBlock((Level)this.world, (BlockPos)this.outputPos, (BlockState)state, (boolean)simulate);
        if (!drainBlock.isEmpty()) {
            if (!simulate && state.hasProperty((Property)BlockStateProperties.LEVEL_HONEY) && AllFluids.HONEY.is((Object)drainBlock.getFluid())) {
                AdvancementBehaviour.tryAward((BlockGetter)this.world, (BlockPos)this.pos, (CreateAdvancement)AllAdvancements.HONEY_DRAIN);
            }
            cir.setReturnValue((Object)drainBlock);
            cir.cancel();
            return;
        }
        if (!waterlog && !state.canBeReplaced()) {
            cir.setReturnValue((Object)empty);
            cir.cancel();
            return;
        }
        if (fluidState.isEmpty() || !fluidState.isSource()) {
            cir.setReturnValue((Object)empty);
            cir.cancel();
            return;
        }
        FluidStack stack = new FluidStack(fluidState.getType(), 1000);
        if (simulate) {
            cir.setReturnValue((Object)stack);
            cir.cancel();
            return;
        }
        if (FluidHelper.isWater((Fluid)stack.getFluid())) {
            AdvancementBehaviour.tryAward((BlockGetter)this.world, (BlockPos)this.pos, (CreateAdvancement)AllAdvancements.WATER_SUPPLY);
        }
        if (waterlog || lavalog) {
            if (waterlog) {
                this.world.setBlock(this.outputPos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
                this.world.scheduleTick(this.outputPos, (Fluid)Fluids.WATER, 1);
                state = this.world.getBlockState(this.outputPos);
            }
            if (lavalog) {
                this.world.setBlock(this.outputPos, (BlockState)state.setValue((Property)createSchematicChecker$LAVALOGGED, (Comparable)Boolean.valueOf(false)), 3);
                this.world.scheduleTick(this.outputPos, (Fluid)Fluids.LAVA, 1);
            }
            cir.setReturnValue((Object)stack);
            cir.cancel();
            return;
        }
        BlockState newState = (BlockState)fluidState.createLegacyBlock().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(14));
        FluidState newFluidState = newState.getFluidState();
        Fluid fluid = newFluidState.getType();
        if (fluid instanceof FlowingFluidAccessor && (potentiallyFilled = (flowing = (FlowingFluidAccessor)fluid).create$getNewLiquid(this.world, this.outputPos, newState)).equals(fluidState)) {
            cir.setReturnValue((Object)stack);
            cir.cancel();
        }
        this.world.setBlock(this.outputPos, newState, 3);
        cir.setReturnValue((Object)stack);
        cir.cancel();
    }

    @Overwrite
    public boolean isEndpoint() {
        return true;
    }
}

