/*
 * Decompiled with CFR 0.152.
 */
package com.Pink_Cats.createschematicchecker.FancyConfig;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigHook {
    public static void writeToml(String filePath, Map<String, String> tomlData) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
            for (Map.Entry<String, String> entry : tomlData.entrySet()) {
                writer.write(entry.getKey() + " = \"" + entry.getValue() + "\"");
                writer.newLine();
            }
        }
    }

    public static Map<String, Object> readToml(String filePath) {
        HashMap<String, Object> tomlData = new HashMap<String, Object>();
        String currentTable = null;
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
                String line;
                StringBuilder arrayValueBuilder = new StringBuilder();
                Object key = null;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    if (line.startsWith("[") && line.endsWith("]")) {
                        currentTable = line.substring(1, line.length() - 1).trim();
                        continue;
                    }
                    if (!line.contains("=")) continue;
                    String[] parts = line.split("=", 2);
                    key = parts[0].trim();
                    String value = parts[1].trim();
                    if (value.startsWith("[")) {
                        arrayValueBuilder.append(value);
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).isEmpty()) continue;
                            String[] splitLine = line.split("#", 2);
                            String cleanLine = splitLine[0].trim();
                            arrayValueBuilder.append(" ").append(cleanLine);
                            if (!cleanLine.endsWith("]")) continue;
                            break;
                        }
                        List<String> arrayValue = ConfigHook.parseArray(arrayValueBuilder.toString());
                        if (currentTable != null) {
                            key = currentTable + "." + (String)key;
                        }
                        tomlData.put((String)key, arrayValue);
                        arrayValueBuilder.setLength(0);
                        continue;
                    }
                    Object valueObj = ConfigHook.parseValue(value);
                    if (currentTable != null) {
                        key = currentTable + "." + (String)key;
                    }
                    tomlData.put((String)key, valueObj);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tomlData;
    }

    private static Object parseValue(String value) {
        if ((value = value.trim()).startsWith("[") && value.endsWith("]")) {
            return ConfigHook.parseArray(value);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return Boolean.parseBoolean(value);
        }
        if (value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        if (value.matches("\\d+\\.\\d+")) {
            return Double.parseDouble(value);
        }
        return value;
    }

    private static List<String> parseArray(String value) {
        String[] items;
        ArrayList<String> arrayValues = new ArrayList<String>();
        value = value.substring(1, value.length() - 1).replace("\n", " ").trim();
        for (String item : items = value.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)")) {
            if ((item = item.trim()).startsWith("\"") && item.endsWith("\"")) {
                item = item.substring(1, item.length() - 1);
            }
            arrayValues.add(item);
        }
        return arrayValues;
    }
}

