/*
 * Decompiled with CFR 0.152.
 */
package com.Pink_Cats.createschematicchecker.event;

import com.Pink_Cats.createschematicchecker.FancyConfig.ConfigRegister;
import com.Pink_Cats.createschematicchecker.core.BlueCore;
import com.Pink_Cats.createschematicchecker.core.BlueEngine.NbtInterFace;
import com.Pink_Cats.createschematicchecker.core.BlueEngine.StrFunc;
import com.Pink_Cats.createschematicchecker.event.SchematicUploadEvent;
import com.Pink_Cats.createschematicchecker.event.TempOffEvent;
import com.Pink_Cats.createschematicchecker.lang.CSCLanguage;
import com.Pink_Cats.createschematicchecker.lang.Message;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.schematics.SchematicItem;
import com.simibubi.create.content.schematics.table.SchematicTableBlockEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CheckBlueprint {
    BlueCore Checker;

    public CheckBlueprint(BlueCore _filter) {
        this.Checker = _filter;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void OnSchematicUpload(SchematicUploadEvent event) {
        new Thread(() -> this.handleBlueprintUpload(event)).start();
    }

    private void handleBlueprintUpload(SchematicUploadEvent event) {
        try {
            SchematicTableBlockEntity table = event.Table;
            Level world = event.World;
            ServerPlayer player = event.Player;
            String PlayerBlueprintId = event.SchematicPath;
            String player_id = player.m_36316_().getName();
            if (table.m_58901_()) {
                return;
            }
            if (!TempOffEvent.CheckSchematic) {
                Message.FE(CSCLanguage.translateDirect("console.stop.csc.temp.output"));
                String DefaultPath = "./schematics/uploaded/";
                String path = DefaultPath + PlayerBlueprintId;
                CompoundTag nbt_data = this.Path_to_CompoundTag(path);
                String User = PlayerBlueprintId.split("/")[0];
                String Blueprint = PlayerBlueprintId.split("/")[1];
                if (ConfigRegister.enable_backup) {
                    this.Checker.CompoundTag_to_Path(nbt_data, "config/CSC/backup/" + User + "/", StrFunc.getCurrentDateTime() + Blueprint);
                }
                this.Checker.CompoundTag_to_Path(nbt_data, DefaultPath + User + "/", Blueprint);
                table.inventory.setStackInSlot(1, SchematicItem.create((HolderGetter)world.m_246945_(Registries.f_256747_), (String)Blueprint, (String)player_id));
                return;
            }
            ArrayList<String> CheatLog = new ArrayList<String>();
            long startTime = System.currentTimeMillis();
            Map<String, Object> CheckResult = this.Checker.SchematicBlueCore(PlayerBlueprintId, CheatLog);
            if (CheckResult == null) {
                table.inventory.setStackInSlot(0, AllItems.EMPTY_SCHEMATIC.asStack());
                return;
            }
            ++ConfigRegister.CheckCount;
            boolean IsCheatSchematic = NbtInterFace.S_bool(CheckResult.get("Cheat"));
            boolean IsProblem = NbtInterFace.S_bool(CheckResult.get("Problem"));
            boolean CannotCheck = NbtInterFace.S_bool(CheckResult.get("CannotCheck"));
            long endTime = System.currentTimeMillis();
            long executionTime = endTime - startTime;
            PlayerBlueprintId = this.removeFirstPathComponent(PlayerBlueprintId);
            if (!CheatLog.isEmpty()) {
                for (String s : CheatLog) {
                    Message.FE(s);
                }
            }
            Message.FP(CSCLanguage.translateDirect("console.total.time") + executionTime + " ms");
            if (CannotCheck) {
                Message.FE(CSCLanguage.translateDirect("console.csc.cannotCheck"));
                table.inventory.setStackInSlot(0, AllItems.EMPTY_SCHEMATIC.asStack());
                return;
            }
            if (!IsCheatSchematic) {
                if (IsProblem) {
                    ++ConfigRegister.ProblemCount;
                    Message.FW(CSCLanguage.translateDirect("console.problemOutput") + player_id + CSCLanguage.translateDirect("console.problemOutput2") + PlayerBlueprintId);
                }
                table.inventory.setStackInSlot(1, SchematicItem.create((HolderGetter)world.m_246945_(Registries.f_256747_), (String)PlayerBlueprintId, (String)player_id));
            } else {
                ++ConfigRegister.CheatCount;
                Message.FE(CSCLanguage.translateDirect("console.cheat.find"));
                Message.FE(CSCLanguage.translateDirect("console.CheatOutput") + player_id + CSCLanguage.translateDirect("console.CheatOutput2") + PlayerBlueprintId);
                if (ConfigRegister.DebugCheatFind) {
                    CheckBlueprint.broadcast(PlayerBlueprintId, player_id);
                }
                if (ConfigRegister.CheckRunCommand) {
                    CheckBlueprint.ExecuteSomeCmd(PlayerBlueprintId, player_id);
                }
                table.inventory.setStackInSlot(0, AllItems.EMPTY_SCHEMATIC.asStack());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CompoundTag Path_to_CompoundTag(String SchematicPath) throws IOException {
        File BluePrint = new File(SchematicPath);
        FileInputStream file_stream = new FileInputStream(BluePrint);
        return NbtIo.m_128939_((InputStream)file_stream);
    }

    public String removeFirstPathComponent(String path) {
        int firstSlashIndex = path.indexOf("/");
        if (firstSlashIndex != -1) {
            return path.substring(firstSlashIndex + 1);
        }
        return path;
    }

    public static List<ServerPlayer> getAllOnlinePlayers() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return new ArrayList<ServerPlayer>();
        }
        return new ArrayList<ServerPlayer>(server.m_6846_().m_11314_());
    }

    public static void broadcast(String PlayerBlueprintId, String PlayerName) {
        for (Player player : CheckBlueprint.getAllOnlinePlayers()) {
            player.m_213846_((Component)Component.m_237113_((String)(CSCLanguage.translateDirect("console.CheatOutput") + PlayerName + CSCLanguage.translateDirect("console.CheatOutput2") + PlayerBlueprintId)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
        }
    }

    public static void ExecuteSomeCmd(String PlayerBlueprintId, String PlayerName) {
        String command = "";
    }
}

