/*
 * Decompiled with CFR 0.152.
 */
package com.Pink_Cats.createschematicchecker.online;

import com.Pink_Cats.createschematicchecker.online.VersionChecker;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HttpsURLConnection;

public class OnlineInterface {
    private static final String _P_2323_ = "https://mc.aisaveworld.tech:8144/";

    public static String OnlineHandler(String method, String data) {
        VersionChecker.disableSSLVerification();
        String RequestUrl = _P_2323_ + method;
        if (method.equals("heartbeat")) {
            return OnlineInterface.SimpleHeartbeatPush(RequestUrl, data);
        }
        return "";
    }

    private static String SimpleHeartbeatPush(String RequestUrl, String data) {
        try {
            HttpsURLConnection conn = (HttpsURLConnection)new URL(RequestUrl).openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            try (OutputStream os = conn.getOutputStream();){
                os.write(data.getBytes(StandardCharsets.UTF_8));
                os.flush();
            }
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                String errorMsg = new String(conn.getErrorStream().readAllBytes(), StandardCharsets.UTF_8);
                throw new IOException("\u63a8\u9001\u5931\u8d25\uff01\u72b6\u6001\u7801\uff1a" + responseCode + "\uff0c\u9519\u8bef\uff1a" + errorMsg);
            }
            String successResp = new String(conn.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
            conn.disconnect();
            return successResp;
        }
        catch (IOException ignored) {
            return "";
        }
    }
}

