/*
 * Decompiled with CFR 0.152.
 */
package com.Pink_Cats.createschematicchecker.online;

import com.Pink_Cats.createschematicchecker.FancyConfig.FileIO;
import com.Pink_Cats.createschematicchecker.lang.CSCLanguage;
import com.Pink_Cats.createschematicchecker.lang.Message;
import com.Pink_Cats.createschematicchecker.network.rule_io;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;

public class VersionChecker {
    public static void disableSSLVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = (hostname, session) -> true;
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fetchDataByGet(String targetUrl) throws Exception {
        VersionChecker.disableSSLVerification();
        HttpsURLConnection conn = VersionChecker.getHttpsURLConnection(targetUrl);
        StringBuilder responseContent = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                responseContent.append(line);
            }
        }
        finally {
            conn.disconnect();
        }
        return responseContent.toString();
    }

    @NotNull
    private static HttpsURLConnection getHttpsURLConnection(String targetUrl) throws IOException {
        HttpsURLConnection conn = VersionChecker.getUrlConnection(targetUrl);
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            throw new IOException(String.format("GET \u8bf7\u6c42\u5931\u8d25\uff01\u5730\u5740\uff1a%s\uff0c\u72b6\u6001\u7801\uff1a%d\uff0c\u72b6\u6001\u63cf\u8ff0\uff1a%s", targetUrl, responseCode, conn.getResponseMessage()));
        }
        return conn;
    }

    @NotNull
    private static HttpsURLConnection getUrlConnection(String targetUrl) throws IOException {
        URL url = new URL(targetUrl);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        conn.setRequestProperty("User-Agent", "Java-HTTPS-GET-Client/1.0");
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(10000);
        return conn;
    }

    private static String fetchServerVersion(String versionUrl) throws IOException {
        String string;
        URL url = new URL(versionUrl);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/json");
        try (OutputStream os = conn.getOutputStream();){
            os.write("{}".getBytes());
            os.flush();
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        try {
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = in.readLine()) != null) {
                response.append(line);
            }
            String json = response.toString();
            int start = json.indexOf(":\"") + 2;
            int end = json.indexOf("\"", start);
            string = json.substring(start, end);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return String.valueOf(new Date());
            }
        }
        in.close();
        return string;
    }

    private static String fetchServerVersionByGet(String versionUrl) throws IOException {
        URL url = new URL(versionUrl);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Content-Type", "application/json");
        try (BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = in.readLine()) != null) {
                response.append(line);
            }
            String json = response.toString();
            int start = json.indexOf(":\"") + 2;
            int end = json.indexOf("\"", start);
            if (start == 1 || end == -1) {
                throw new IOException("\u670d\u52a1\u5668\u54cd\u5e94\u683c\u5f0f\u9519\u8bef\uff0c\u65e0\u6cd5\u89e3\u6790\u7248\u672c\uff1a" + json);
            }
            String string = json.substring(start, end);
            return string;
        }
    }

    private static void downloadFile(String baseUrl, String version, String savePath) throws IOException {
        String fileUrl = baseUrl + "?version=" + URLEncoder.encode(version, StandardCharsets.UTF_8);
        URL url = new URL(fileUrl);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        try (InputStream in = conn.getInputStream();
             FileOutputStream out = new FileOutputStream(savePath);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Date parseVersionDate(String version) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
            return sdf.parse(version);
        }
        catch (ParseException e) {
            Message.FE("Date Parse error: " + e.getMessage());
            return new Date();
        }
    }

    public static Date getLocalVersion(String path) {
        File directory = new File(path);
        List<Object> jsonFiles = new ArrayList();
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                    jsonFiles.add(file);
                }
            }
        } else {
            Message.FE("\u6307\u5b9a\u8def\u5f84\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u76ee\u5f55: " + path);
        }
        if (jsonFiles.size() > 2) {
            jsonFiles.sort((f1, f2) -> Long.compare(f2.lastModified(), f1.lastModified()));
            for (int i = 2; i < jsonFiles.size(); ++i) {
                File fileToDelete = (File)jsonFiles.get(i);
                if (!fileToDelete.delete()) continue;
            }
            jsonFiles = jsonFiles.subList(0, 2);
        }
        if (jsonFiles.isEmpty()) {
            return VersionChecker.parseVersionDate("2010_10_10_10_10_10");
        }
        Date versionDate = null;
        for (File file : jsonFiles) {
            Date itemDate = VersionChecker.parseVersionDate(file.getName().replaceAll("rule_(.*)\\.json", "$1"));
            if (versionDate != null && !itemDate.after(versionDate)) continue;
            versionDate = itemDate;
        }
        return versionDate;
    }

    public static String UpdateMainThread() {
        String BaseOnlinePath = "config/CSC/online";
        FileIO.createIfNotExists(BaseOnlinePath);
        String versionUrl = "https://mc.aisaveworld.tech:8144/Version";
        String fileBaseUrl = "https://mc.aisaveworld.tech:8144/GetLatestRule";
        try {
            VersionChecker.disableSSLVerification();
            String serverVersion = VersionChecker.fetchServerVersion(versionUrl);
            Date serverDate = VersionChecker.parseVersionDate(serverVersion);
            Date localDate = VersionChecker.getLocalVersion(BaseOnlinePath);
            String path = BaseOnlinePath + "/rule_" + serverVersion + ".json";
            if (localDate.before(serverDate)) {
                Message.FM(CSCLanguage.translateDirect("csc.update.start"));
                VersionChecker.downloadFile(fileBaseUrl, serverVersion, path);
                Message.FM(CSCLanguage.translateDirect("csc.update.success"));
            }
            rule_io.RuleFixer(path);
            return path;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String Result = VersionChecker.fetchDataByGet("https://mc.aisaveworld.tech:8144/server_feedback");
    }
}

