/*
 * Decompiled with CFR 0.152.
 */
package com.Pink_Cats.createschematicchecker.event;

import com.Pink_Cats.createschematicchecker.FancyConfig.ConfigRegister;
import com.Pink_Cats.createschematicchecker.core.BlueCore;
import com.Pink_Cats.createschematicchecker.core.BlueEngine.NbtInterFace;
import com.Pink_Cats.createschematicchecker.event.SchematicUploadEvent;
import com.Pink_Cats.createschematicchecker.lang.CSCLanguage;
import com.Pink_Cats.createschematicchecker.lang.Message;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.schematics.SchematicItem;
import com.simibubi.create.content.schematics.table.SchematicTableBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class CheckBlueprint {
    BlueCore Checker;

    public CheckBlueprint(BlueCore _filter) {
        this.Checker = _filter;
    }

    @SubscribeEvent
    public void OnSchematicUpload(SchematicUploadEvent event) {
        new Thread(() -> this.handleBlueprintUpload(event)).start();
    }

    private void handleBlueprintUpload(SchematicUploadEvent event) {
        try {
            SchematicTableBlockEntity table = event.Table;
            Level world = event.World;
            ServerPlayer player = event.Player;
            String PlayerBlueprintId = event.SchematicPath;
            if (table.isRemoved()) {
                return;
            }
            ArrayList<String> CheatLog = new ArrayList<String>();
            long startTime = System.currentTimeMillis();
            Map<String, Object> CheckResult = this.Checker.SchematicBlueCore(PlayerBlueprintId, CheatLog);
            ++ConfigRegister.CheckCount;
            boolean IsCheatSchematic = NbtInterFace.S_bool(CheckResult.get("Cheat"));
            boolean IsProblem = NbtInterFace.S_bool(CheckResult.get("Problem"));
            String player_id = player.getGameProfile().getName();
            long endTime = System.currentTimeMillis();
            long executionTime = endTime - startTime;
            PlayerBlueprintId = this.removeFirstPathComponent(PlayerBlueprintId);
            if (!CheatLog.isEmpty()) {
                for (String s : CheatLog) {
                    Message.FE(s);
                }
            }
            Message.FP(CSCLanguage.translateDirect("console.total.time") + executionTime + " ms");
            if (!IsCheatSchematic) {
                if (IsProblem) {
                    ++ConfigRegister.ProblemCount;
                    Message.FW(CSCLanguage.translateDirect("console.problemOutput") + player_id + CSCLanguage.translateDirect("console.problemOutput2") + PlayerBlueprintId);
                }
                table.inventory.setStackInSlot(1, SchematicItem.create((Level)world, (String)PlayerBlueprintId, (String)player_id));
            } else {
                ++ConfigRegister.CheatCount;
                Message.FE(CSCLanguage.translateDirect("console.cheat.find"));
                Message.FE(CSCLanguage.translateDirect("console.CheatOutput") + player_id + CSCLanguage.translateDirect("console.CheatOutput2") + PlayerBlueprintId);
                if (ConfigRegister.DebugCheatFind) {
                    CheckBlueprint.broadcast(PlayerBlueprintId, player_id);
                }
                table.inventory.setStackInSlot(0, AllItems.EMPTY_SCHEMATIC.asStack());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String removeFirstPathComponent(String path) {
        int firstSlashIndex = path.indexOf("/");
        if (firstSlashIndex != -1) {
            return path.substring(firstSlashIndex + 1);
        }
        return path;
    }

    public static List<ServerPlayer> getAllOnlinePlayers() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return new ArrayList<ServerPlayer>();
        }
        return new ArrayList<ServerPlayer>(server.getPlayerList().getPlayers());
    }

    public static void broadcast(String PlayerBlueprintId, String PlayerName) {
        for (Player player : CheckBlueprint.getAllOnlinePlayers()) {
            player.sendSystemMessage((Component)Component.literal((String)(CSCLanguage.translateDirect("console.CheatOutput") + PlayerName + CSCLanguage.translateDirect("console.CheatOutput2") + PlayerBlueprintId)).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)));
        }
    }
}

