/*
 * Decompiled with CFR 0.152.
 */
package com.Pink_Cats.createschematicchecker.mixin;

import com.Pink_Cats.createschematicchecker.event.SchematicUploadEvent;
import com.Pink_Cats.createschematicchecker.lang.CSCLanguage;
import com.Pink_Cats.createschematicchecker.lang.Message;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.schematics.ServerSchematicLoader;
import com.simibubi.create.content.schematics.table.SchematicTableBlockEntity;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerSchematicLoader.class}, remap=false)
public abstract class handleFinishedUploadMixin {
    @Shadow
    private Map<String, ServerSchematicLoader.SchematicUploadEntry> activeUploads;

    @Shadow
    public abstract SchematicTableBlockEntity getTable(Level var1, BlockPos var2);

    @Inject(method={"handleFinishedUpload"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void OnSchematicOnLoaded(ServerPlayer player, String schematic, CallbackInfo ctr) {
        String playerSchematicId = player.getGameProfile().getName() + "/" + schematic;
        if (this.activeUploads.containsKey(playerSchematicId)) {
            try {
                this.activeUploads.get((Object)playerSchematicId).stream.close();
                ServerSchematicLoader.SchematicUploadEntry removed = this.activeUploads.remove(playerSchematicId);
                Level world = removed.world;
                BlockPos pos = removed.tablePos;
                Message.FM(CSCLanguage.translateDirect("console.newSchematic") + playerSchematicId);
                if (pos == null) {
                    return;
                }
                BlockState blockState = world.getBlockState(pos);
                if (AllBlocks.SCHEMATIC_TABLE.get() != blockState.getBlock()) {
                    return;
                }
                SchematicTableBlockEntity table = this.getTable(world, pos);
                if (table == null) {
                    return;
                }
                table.finishUpload();
                SchematicUploadEvent uploadEvent = new SchematicUploadEvent(player, playerSchematicId, schematic, world, table);
                NeoForge.EVENT_BUS.post((Event)uploadEvent);
                ctr.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

