/*
 * Decompiled with CFR 0.152.
 */
package com.Pink_Cats.createschematicchecker.network;

import com.Pink_Cats.createschematicchecker.FancyConfig.ConfigRegister;
import com.Pink_Cats.createschematicchecker.FancyConfig.FileIO;
import com.Pink_Cats.createschematicchecker.lang.CSCLanguage;
import com.Pink_Cats.createschematicchecker.lang.Message;
import com.Pink_Cats.createschematicchecker.online.VersionChecker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleJsonParser {
    private static final String INITIAL_JSON_CONTENT = "{\n  \"id\": [\n    [\"minecraft:item\", \"path.path.$list\"]\n  ],\n  \"operate\": [\n    [\"create:dirt\", \"path.path.$list,para\", \"operate.limit$para$0$4\"],\n    [\"create:item\", \"path.path.para\", \"operate.clear$para\"]\n  ]\n}";

    public static String[][][] parseJsonToArrays(String filePath, List<String> log) {
        try {
            List<String> lines = SimpleJsonParser.readAllLines(filePath);
            if (lines == null) {
                return null;
            }
            if (!SimpleJsonParser.validateBasicFormat(lines, log)) {
                return null;
            }
            String[][] idArray = SimpleJsonParser.parseTwoDimensionalArray(lines, "id", log);
            String[][] operateArray = SimpleJsonParser.parseTwoDimensionalArray(lines, "operate", log);
            if (idArray == null) {
                idArray = new String[0][0];
            }
            if (operateArray == null) {
                operateArray = new String[0][0];
            }
            return new String[][][]{idArray, operateArray};
        }
        catch (Exception e) {
            log.add("console.miss.fail.parse" + e.getMessage());
            Message.FE("console.miss.fail.parse" + e.getMessage());
            return null;
        }
    }

    private static List<String> readAllLines(String filePath) {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line.trim());
            }
        }
        catch (IOException e) {
            return null;
        }
        return lines.isEmpty() ? null : lines;
    }

    private static boolean validateBasicFormat(List<String> lines, List<String> log) {
        if (lines == null || lines.isEmpty()) {
            log.add(CSCLanguage.translateDirect("console.miss.json.empty"));
            return false;
        }
        if (!lines.get(0).startsWith("{")) {
            log.add(CSCLanguage.translateDirect("console.miss.json.start"));
            return false;
        }
        if (!lines.get(lines.size() - 1).endsWith("}")) {
            log.add(CSCLanguage.translateDirect("console.miss.json.stop") + lines.size());
            return false;
        }
        return true;
    }

    private static String[][] parseTwoDimensionalArray(List<String> lines, String fieldName, List<String> log) {
        int fieldLineIndex = -1;
        for (int i = 0; i < lines.size(); ++i) {
            if (!lines.get(i).startsWith("\"" + fieldName + "\":")) continue;
            fieldLineIndex = i;
            break;
        }
        if (fieldLineIndex == -1) {
            return null;
        }
        String fieldLine = lines.get(fieldLineIndex);
        int arrayStart = fieldLine.indexOf(91);
        if (arrayStart == -1) {
            log.add(fieldName + CSCLanguage.translateDirect("console.miss.liner") + (fieldLineIndex + 1) + "\uff09");
            return null;
        }
        StringBuilder arrayContent = new StringBuilder();
        int bracketLevel = 1;
        arrayContent.append(fieldLine.substring(arrayStart));
        for (int i = fieldLineIndex + 1; i < lines.size(); ++i) {
            String line = lines.get(i);
            arrayContent.append(line);
            for (char c : line.toCharArray()) {
                if (c == '[') {
                    ++bracketLevel;
                }
                if (c == ']') {
                    --bracketLevel;
                }
                if (bracketLevel == 0) break;
            }
            if (bracketLevel == 0) break;
        }
        return SimpleJsonParser.parseTwoDimensionalArrayString(arrayContent.toString(), log);
    }

    public static String removeLastComma(String input) {
        if (input != null && !input.isEmpty() && input.charAt(input.length() - 1) == ',') {
            return input.substring(0, input.length() - 1);
        }
        return input;
    }

    private static String[][] parseTwoDimensionalArrayString(String arrayStr, List<String> log) {
        if (!(arrayStr = SimpleJsonParser.removeLastComma(arrayStr)).startsWith("[") || !arrayStr.endsWith("]")) {
            return null;
        }
        String innerContent = arrayStr.substring(1, arrayStr.length() - 1).trim();
        if (innerContent.isEmpty()) {
            return new String[0][0];
        }
        ArrayList<String> subArrayStrs = new ArrayList<String>();
        int start = 0;
        int bracketLevel = 0;
        for (int i = 0; i < innerContent.length(); ++i) {
            char c = innerContent.charAt(i);
            if (c == '[') {
                ++bracketLevel;
            }
            if (c == ']') {
                --bracketLevel;
            }
            if (c != ',' || bracketLevel != 0) continue;
            subArrayStrs.add(innerContent.substring(start, i).trim());
            start = i + 1;
        }
        subArrayStrs.add(innerContent.substring(start).trim());
        ArrayList<String[]> resultList = new ArrayList<String[]>();
        for (String subArrayStr : subArrayStrs) {
            String[] subArray = SimpleJsonParser.parseOneDimensionalArrayString(subArrayStr, log);
            if (subArray == null) {
                return null;
            }
            resultList.add(subArray);
        }
        return (String[][])resultList.toArray((T[])new String[0][]);
    }

    private static String[] parseOneDimensionalArrayString(String arrayStr, List<String> log) {
        if (!arrayStr.startsWith("[") || !arrayStr.endsWith("]")) {
            log.add(CSCLanguage.translateDirect("console.miss.format") + arrayStr);
            return null;
        }
        String innerContent = arrayStr.substring(1, arrayStr.length() - 1).trim();
        if (innerContent.isEmpty()) {
            return new String[0];
        }
        List<String> elements = SimpleJsonParser.getStrings(innerContent);
        String[] result = new String[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            String elem = elements.get(i);
            result[i] = elem.startsWith("\"") && elem.endsWith("\"") ? elem.substring(1, elem.length() - 1) : elem;
        }
        return result;
    }

    @NotNull
    private static List<String> getStrings(String innerContent) {
        ArrayList<String> elements = new ArrayList<String>();
        int start = 0;
        boolean inQuotes = false;
        for (int i = 0; i < innerContent.length(); ++i) {
            char c = innerContent.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (c != ',' || inQuotes) continue;
            elements.add(innerContent.substring(start, i).trim());
            start = i + 1;
        }
        elements.add(innerContent.substring(start).trim());
        return elements;
    }

    private static boolean ConfigIsValid(String[][][] result, List<String> log) {
        if (result != null) {
            String[][] idArray = result[0];
            String[][] operateArray = result[1];
            for (String[] subArray : idArray) {
                if (subArray.length != 2) {
                    log.add(CSCLanguage.translateDirect("console.miss.length2") + subArray.length);
                    return false;
                }
                if (subArray[0].contains(":")) continue;
                log.add(CSCLanguage.translateDirect("console.miss.id") + subArray[0]);
                return false;
            }
            for (String[] subArray : operateArray) {
                if (subArray.length != 3) {
                    log.add(CSCLanguage.translateDirect("console.miss.length3") + subArray.length);
                    return false;
                }
                if (!subArray[0].contains(":")) {
                    log.add(CSCLanguage.translateDirect("console.miss.id") + subArray[0]);
                    return false;
                }
                if (!subArray[2].contains("operate")) {
                    log.add(CSCLanguage.translateDirect("console.miss.operate2") + subArray[2]);
                    return false;
                }
                if (subArray[2].contains("limit") || subArray[2].contains("clear") || subArray[2].contains("replace")) continue;
                log.add(CSCLanguage.translateDirect("console.miss.operate") + subArray[2]);
                return false;
            }
        }
        return true;
    }

    public static void ArrayListOutput(String[][] result) {
        if (result != null) {
            for (Object[] objectArray : result) {
                Message.FM(Arrays.toString(objectArray));
            }
        }
    }

    public static String[][] merge(String[][] first, String[][] second) {
        if (first == null) {
            return second == null ? new String[][]{} : (String[][])second.clone();
        }
        if (second == null) {
            return (String[][])first.clone();
        }
        String[][] result = new String[first.length + second.length][];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static void createUserRuleFile(String directoryPath, String fileName) {
        File file = new File(directoryPath, fileName);
        if (file.exists()) {
            return;
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write(INITIAL_JSON_CONTENT);
        }
        catch (IOException e) {
            Message.FE(CSCLanguage.translateDirect("console.makefile.error") + e.getMessage());
        }
    }

    public static List<String> UpdateRuleThread(List<String> log) {
        String jsonPath = VersionChecker.UpdateMainThread();
        String UserRulePath = "config/CSC";
        FileIO.createIfNotExists(UserRulePath);
        String UserRuleFile = "user_rule.json";
        SimpleJsonParser.createUserRuleFile(UserRulePath, UserRuleFile);
        String[][] SurgeryExist = new String[][]{{"create:belt", "nbt.Length", "operate.limit$Length$0$" + ConfigRegister.MaxBelt}, {"create:belt", "nbt.Index", "operate.limit$Index$0$" + ConfigRegister.MaxIndex}, {"create:weighted_ejector", "nbt.HorizontalDistance", "operate.limit$HorizontalDistance$1$" + ConfigRegister.MaxEject}, {"create:deployer", "nbt.Inventory", "operate.clear$Inventory"}, {"create:andesite_funnel", "nbt.Filter", "operate.clear$Filter"}, {"create:andesite_funnel", "nbt.FilterAmount", "operate.clear$FilterAmount"}, {"create:mechanical_arm", "nbt.$InteractionPoints.Pos.X", "operate.limit$X$-5$5"}, {"create:mechanical_arm", "nbt.$InteractionPoints.Pos.Y", "operate.limit$Y$-5$5"}, {"create:mechanical_arm", "nbt.$InteractionPoints.Pos.Z", "operate.limit$Z$-5$5"}, {"create:chassis", "nbt.ScrollValue", "operate.limit$ScrollValue$0$" + ConfigRegister.MaxChassisRange}, {"createaddition:rolling_mill", "nbt.InputInventory", "operate.clear$InputInventory"}, {"createaddition:rolling_mill", "nbt.OutputInventory", "operate.clear$OutputInventory"}, {"create_enchantment_industry:printer", "nbt.PrintingTemplate", "operate.clear$PrintingTemplate"}, {"createbigcannons:fuzed_block", "nbt.Fuze", "operate.clear$Fuze"}, {"create:package_frogport", "nbt.Inventory", "operate.clear$Inventory"}};
        String[][] IdLogicArray = new String[][]{{"create:stock_ticker", "nbt.$Categories.id"}, {"create:redstone_requester", "nbt.EncodedRequest.ordered_stacks.$entries.item_stack.id"}, {"create:factory_panel", "nbt.bottom_left.Filter.id"}, {"create:factory_panel", "nbt.top_left.Filter.id"}, {"create:factory_panel", "nbt.bottom_right.Filter.id"}, {"create:factory_panel", "nbt.top_right.Filter.id"}, {"create:redstone_requester", "nbt.EncodedRequest.OrderedStacks.$Entries.Item.id"}, {"create:table_cloth", "nbt.$Items.id"}, {"create:package_frogport", "nbt.Inventory.$Items.id"}, {"create:package_postbox", "nbt.Inventory.$Items.id"}, {"create:redstone_link", "nbt.FrequencyFirst.id"}, {"create:redstone_link", "nbt.FrequencyLast.id"}, {"create:depot", "nbt.HeldItem.Item.id"}, {"create:weighted_ejector", "nbt.HeldItem.Item.id"}, {"create:chute", "nbt.Item.id"}, {"create:smart_chute", "nbt.Item.id"}, {"create:smart_chute", "nbt.Filter.id"}, {"create:saw", "nbt.Filter.id"}, {"create:deployer", "nbt.Filter.id"}, {"create:deployer", "nbt.$Inventory.id"}, {"create:funnel", "nbt.Filter.id"}, {"create:placard", "nbt.Item.id"}, {"create:content_observer", "nbt.Filter.id"}, {"create:belt", "nbt.Inventory.$Items.Item.id"}, {"create:basin", "nbt.Filter.id"}, {"create:basin", "nbt.InputItems.$Items.id"}, {"create:basin", "nbt.OutputItems.$Items.id"}, {"create:smart_fluid_pipe", "nbt.Filter.id"}, {"create:mechanical_crafter", "nbt.Inventory.$Items.id"}, {"create:toolbox", "nbt.Inventory.$Compartments.id"}, {"create:toolbox", "nbt.Inventory.$Items.id"}, {"create:stockpile_switch", "nbt.Filter.id"}, {"create:brass_tunnel", "nbt.Filter.id"}, {"create:brass_tunnel", "nbt.$Filters.Filter.id"}, {"create:brass_tunnel", "nbt.StackToDistribute.id"}, {"create:mechanical_roller", "nbt.Filter.id"}, {"create:creative_crate", "nbt.Filter.id"}};
        ConfigRegister.Operate_modify_rule_local = SurgeryExist;
        ConfigRegister.ID_modify_rule_local = IdLogicArray;
        if (ConfigRegister.enable_auto_config_update) {
            try {
                String[][] idArray = new String[][]{};
                String[][] operateArray = new String[][]{};
                String[][][] result = SimpleJsonParser.parseJsonToArrays(jsonPath, log);
                boolean valid = SimpleJsonParser.ConfigIsValid(result, log);
                if (valid) {
                    if (result != null) {
                        idArray = result[0];
                    }
                    if (result != null) {
                        operateArray = result[1];
                    }
                    if (operateArray.length != 0) {
                        ConfigRegister.Operate_modify_rule_online = operateArray;
                        SurgeryExist = SimpleJsonParser.merge(SurgeryExist, operateArray);
                    }
                    if (idArray.length != 0) {
                        ConfigRegister.ID_modify_rule_online = idArray;
                        IdLogicArray = SimpleJsonParser.merge(IdLogicArray, idArray);
                    }
                }
            }
            catch (Exception e) {
                Message.FE(CSCLanguage.translateDirect("console.config.online.read.error") + e.getMessage());
            }
        }
        if (ConfigRegister.enable_manual_config) {
            try {
                String[][] idArray2 = new String[][]{};
                String[][] operateArray2 = new String[][]{};
                String[][][] result2 = SimpleJsonParser.parseJsonToArrays(UserRulePath + "/" + UserRuleFile, log);
                boolean valid2 = SimpleJsonParser.ConfigIsValid(result2, log);
                if (valid2) {
                    if (result2 != null) {
                        idArray2 = result2[0];
                    }
                    if (result2 != null) {
                        operateArray2 = result2[1];
                    }
                    if (operateArray2.length != 0) {
                        ConfigRegister.Operate_modify_rule_manual = operateArray2;
                        SurgeryExist = SimpleJsonParser.merge(SurgeryExist, operateArray2);
                    }
                    if (idArray2.length != 0) {
                        ConfigRegister.ID_modify_rule_manual = idArray2;
                        IdLogicArray = SimpleJsonParser.merge(IdLogicArray, idArray2);
                    }
                }
            }
            catch (Exception e) {
                Message.FE(CSCLanguage.translateDirect("console.config.manual.read.error") + e.getMessage());
            }
        }
        ConfigRegister.ID_match_rule = IdLogicArray;
        ConfigRegister.Operate_match_rule = SurgeryExist;
        return log;
    }

    public static void main(String[] args) {
        ArrayList<String> log = new ArrayList<String>();
        SimpleJsonParser.UpdateRuleThread(log);
        Message.FP(Arrays.toString(log.toArray()));
    }
}

