/*
 * Decompiled with CFR 0.152.
 */
package com.Pink_Cats.createschematicchecker;

import com.Pink_Cats.createschematicchecker.FancyConfig.ConfigRegister;
import com.Pink_Cats.createschematicchecker.core.BlueCore;
import com.Pink_Cats.createschematicchecker.core.attach.Math;
import com.Pink_Cats.createschematicchecker.database.SingleLog;
import com.Pink_Cats.createschematicchecker.echo.Commands;
import com.Pink_Cats.createschematicchecker.event.CheckBlueprint;
import com.Pink_Cats.createschematicchecker.lang.CSCLanguage;
import com.Pink_Cats.createschematicchecker.lang.Message;
import com.mojang.logging.LogUtils;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CKinetics;
import com.simibubi.create.infrastructure.config.CSchematics;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="createschematicchecker")
public class Createschematicchecker {
    public static final String MODID = "createschematicchecker";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Createschematicchecker() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        BlueCore shifter = new BlueCore();
        MinecraftForge.EVENT_BUS.register((Object)new CheckBlueprint(shifter));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Message.FM(CSCLanguage.translateDirect("console.LoadingConfig"));
        List<String> log = List.of();
        ConfigRegister.CSC_Variables_Load();
        ConfigRegister.CSC_INIT(log);
    }

    public CSchematics CreateSchematicConfig() {
        return AllConfigs.server().schematics;
    }

    public CKinetics CreateCKineticsConfig() {
        return AllConfigs.server().kinetics;
    }

    public void CreateConfigInject() {
        try {
            ConfigRegister.CannonDelay = ((Integer)this.CreateSchematicConfig().schematicannonDelay.get()).toString();
            ConfigRegister.MaxBelt = ((Integer)this.CreateCKineticsConfig().maxBeltLength.get()).toString();
            ConfigRegister.MaxIndex = String.valueOf(Math.StringToInt(ConfigRegister.MaxBelt) - 1);
            ConfigRegister.MaxEject = ((Integer)this.CreateCKineticsConfig().maxEjectorDistance.get()).toString();
            ConfigRegister.MaxChassisRange = ((Integer)this.CreateCKineticsConfig().maxChassisRange.get()).toString();
            try {
                CKinetics config = this.CreateCKineticsConfig();
                Class<?> ckClass = config.getClass();
                Field field = ckClass.getDeclaredField("maxChainConveyorLength");
                field.setAccessible(true);
                Object fieldValue = field.get(config);
                ConfigRegister.CreateVersion = "6.0";
            }
            catch (Exception e) {
                ConfigRegister.CreateVersion = "0.5";
            }
        }
        catch (Exception ex) {
            Message.FE(CSCLanguage.translateDirect("console.ConfigInjectCreateError"));
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.CreateConfigInject();
        SingleLog.CSC_MES.reopen();
        SingleLog.CSC_WARN.reopen();
        Message.FM("   _____  _____  _____ ");
        Message.FM("  / ____|/ ____|/ ____|");
        Message.FM(" | |    | (___ | |        " + CSCLanguage.translateDirect("console.CscVersion"));
        Message.FM(" | |     \\___ \\| |        " + CSCLanguage.translateDirect("console.McVersion"));
        Message.FM(" | |____ ____) | |____    " + CSCLanguage.translateDirect("console.feedback"));
        Message.FM("  \\_____|_____/ \\_____|");
        Message.FM("                       ");
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        ConfigRegister.CSC_Variables_Save();
        Message.FM(CSCLanguage.translateDirect("console.csc.StopServer"));
        SingleLog.CSC_MES.close();
        SingleLog.CSC_WARN.close();
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        try {
            ConfigRegister.CSC_RELOAD();
        }
        catch (Exception ex) {
            Message.FE(CSCLanguage.translateDirect("console.ConfigReloadError"));
        }
    }

    @SubscribeEvent
    public void onCommandRegister(RegisterCommandsEvent event) {
        Commands.RegisterCSCCommand(event);
    }
}

