package gg.pyro.more_enchanting.client.datagen;

import gg.pyro.more_enchanting.enchantment.*;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricDynamicRegistryProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.minecraft.class_1887;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9701;
import net.minecraft.class_9703;
import java.util.concurrent.CompletableFuture;

public class EnchantmentGenerator extends FabricDynamicRegistryProvider {
    public EnchantmentGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    protected void configure(class_7225.class_7874 registries, Entries entries) {
        register(entries, MoreEnchantingEnchantments.DOUBLE_JUMP, class_1887.method_60030(
                class_1887.method_58442(
                        registries.method_46762(class_7924.field_41197).method_46735(class_3489.field_48294),
                        3,
                        1,
                        class_1887.method_58441(1, 20),
                        class_1887.method_58441(1, 20),
                        10,
                        class_9274.field_49224
                )
        ));

        register(entries, MoreEnchantingEnchantments.ROOTED, class_1887.method_60030(
                class_1887.method_58442(
                        registries.method_46762(class_7924.field_41197).method_46735(class_3489.field_48295),
                        5,
                        2,
                        class_1887.method_58441(1, 20),
                        class_1887.method_58441(1, 25),
                        8,
                        class_9274.field_49224
                )
        ).method_60066(
                class_9701.field_51671,
                new RootedEnchantmentEffect()
            )
        );

        register(entries, MoreEnchantingEnchantments.SOUL_ANCHOR, class_1887.method_60030(
                class_1887.method_58442(
                        registries.method_46762(class_7924.field_41197).method_46735(class_3489.field_48296),
                        4,
                        1,
                        class_1887.method_58441(1, 25),
                        class_1887.method_58441(1, 25),
                        5,
                        class_9274.field_49224
                )
        ).method_60066(
                class_9701.field_51671,
                new SoulAnchorEnchantmentEffect()
            )
        );

        register(entries, MoreEnchantingEnchantments.DESPERATION, class_1887.method_60030(
                class_1887.method_58442(
                        registries.method_46762(class_7924.field_41197).method_46735(class_3489.field_48305),
                        4,
                        3,
                        class_1887.method_58441(1, 20),
                        class_1887.method_58441(1, 30),
                        8,
                        class_9274.field_49217
                )
            ).method_60066(
                class_9701.field_51671,
                new DesperationEnchantmentEffect()
            )
        );

        register(entries, MoreEnchantingEnchantments.LEECH, class_1887.method_60030(
                class_1887.method_58442(
                        registries.method_46762(class_7924.field_41197).method_46735(class_3489.field_48305),
                        2,
                        3,
                        class_1887.method_58441(1, 20),
                        class_1887.method_58441(1, 30),
                        8,
                        class_9274.field_49217
                )
        ).method_60063(
                class_9701.field_51665,
                class_9703.field_51683,
                class_9703.field_51685,
                new LeechEnchantmentEffect()
            )
        );

        register(entries, MoreEnchantingEnchantments.MOMENTUM, class_1887.method_60030(
                class_1887.method_58442(
                        registries.method_46762(class_7924.field_41197).method_46735(class_3489.field_50108),
                        6,
                        2,
                        class_1887.method_58441(1, 15),
                        class_1887.method_58441(1, 20),
                        6,
                        class_9274.field_49217
                )
            ).method_60066(
                class_9701.field_51671,
                new MomentumEnchantmentEffect()
            )
        );

        register(entries, MoreEnchantingEnchantments.MARKING, class_1887.method_60030(
                class_1887.method_58442(
                        registries.method_46762(class_7924.field_41197).method_46735(class_3489.field_48305),
                        3,
                        3,
                        class_1887.method_58441(1, 25),
                        class_1887.method_58441(1, 35),
                        10,
                        class_9274.field_49217
                )
            ).method_60063(
                class_9701.field_51665,
                class_9703.field_51683,
                class_9703.field_51685,
                new MarkingEnchantmentEffect()
            )
        );

        register(entries, MoreEnchantingEnchantments.FROST_ASPECT, class_1887.method_60030(
                class_1887.method_58442(
                        registries.method_46762(class_7924.field_41197).method_46735(class_3489.field_48304),
                        2,
                        3,
                        class_1887.method_58441(1, 15),
                        class_1887.method_58441(1, 25),
                        5,
                        class_9274.field_49217
                )
            ).method_60063(
                class_9701.field_51665,
                class_9703.field_51683,
                class_9703.field_51685,
                new FrostAspectEnchantmentEffect()
            )
        );
    }

    private void register(Entries entries, class_5321<class_1887> key, class_1887.class_9700 builder, ResourceCondition... resourceConditions) {
        entries.add(key, builder.method_60060(key.method_29177()), resourceConditions);
    }

    @Override
    public String method_10321() {
        return "MoreEnchantingEnchantmentGenerator";
    }
}