package gg.pyro.more_enchanting.enchantment;

import com.mojang.serialization.MapCodec;
import gg.pyro.more_enchanting.MoreEnchanting;
import gg.pyro.more_enchanting.MoreEnchantingConfig;
import gg.pyro.more_enchanting.components.MoreEnchantingComponents;
import net.minecraft.class_1297;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_9699;
import net.minecraft.class_9721;

public record MomentumEnchantmentEffect() implements class_9721 {

    public static final MapCodec<MomentumEnchantmentEffect> CODEC = MapCodec.unit(MomentumEnchantmentEffect::new);

    public static final class_2960 MOMENTUM_BOOST = MoreEnchanting.id("momentum_enchantment_attack_speed_boost");

    @Override
    public void method_60220(class_3218 world, int level, class_9699 context, class_1297 user, class_243 pos) {
        if (!(user instanceof class_1657 player) || world.method_8608()) return;

        var attackSpeed = player.method_5996(class_5134.field_23723);
        double time = MoreEnchantingConfig.CONFIG.momentumBaseTimer
                + (MoreEnchantingConfig.CONFIG.momentumSecondaryTimer
                / player.method_45325(class_5134.field_23723)
                + MoreEnchantingConfig.CONFIG.momentumPerLevelTimer * level);
        int attackTime = player.field_6012 - player.method_6083();
        final int hits = player.getComponent(MoreEnchantingComponents.ENCHANTMENT_DATA_COMPONENT).hits;

        if (!attackSpeed.method_6196(MOMENTUM_BOOST) &&
                attackTime < time &&
                hits > 2) {
            double boost =  Math.min(1, hits / (7.5 - level));
            attackSpeed.method_26835(new class_1322(MOMENTUM_BOOST, boost, class_1322.class_1323.field_6328));
        } else if (attackTime >= time) {
            if (attackSpeed.method_6196(MOMENTUM_BOOST)) {
                attackSpeed.method_6200(MOMENTUM_BOOST);
            }
            player.getComponent(MoreEnchantingComponents.ENCHANTMENT_DATA_COMPONENT).hits = 0;
        } else if (attackTime >= time / 2 && hits == 0 && attackSpeed.method_6196(MOMENTUM_BOOST)) {
            attackSpeed.method_6200(MOMENTUM_BOOST);
        }
    }

    @Override
    public MapCodec<? extends class_9721> method_60219() {
        return CODEC;
    }
}
