package gg.pyro.more_enchanting.network;

import gg.pyro.more_enchanting.MoreEnchanting;
import gg.pyro.more_enchanting.MoreEnchantingConfig;
import gg.pyro.more_enchanting.components.MoreEnchantingComponents;
import gg.pyro.more_enchanting.enchantment.MoreEnchantingEnchantments;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1304;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record DoubleJumpPacket() implements class_8710 {
    public static final class_8710.class_9154<DoubleJumpPacket> ID =
            new class_8710.class_9154<>(MoreEnchanting.id("double_jump"));

    public static final class_9139<class_9129, DoubleJumpPacket> CODEC =
            class_9139.method_56431(new DoubleJumpPacket());

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public static void register() {
        PayloadTypeRegistry.playC2S().register(ID, CODEC);
    }

    public static void registerServer() {
        ServerPlayNetworking.registerGlobalReceiver(ID, (payload, context) -> {
            context.server().execute(() -> {
                class_3222 player = context.player();

                if (player.getComponent(MoreEnchantingComponents.ENCHANTMENT_DATA_COMPONENT).canDoubleJump &&
                        !player.method_24828() &&
                        !player.method_5869() &&
                        player.method_18798().field_1351 < 0.2 &&
                        player.method_6118(class_1304.field_6166).method_7942() &&
                        player.method_6118(class_1304.field_6166).method_58657().method_57539().stream()
                        .anyMatch(entry -> entry.getKey().method_40230().isPresent() &&
                                entry.getKey().method_40230().get().equals(MoreEnchantingEnchantments.DOUBLE_JUMP))
                ) {
                    double fallDistance = player.field_6017;
                    class_243 velocity = player.method_18798();
                    player.method_18800(
                            velocity.field_1352 != 0 ? velocity.field_1352 + velocity.field_1352 / 3 : 0,
                            MoreEnchantingConfig.CONFIG.doubleJumpVelocity,
                            velocity.field_1350 != 0 ? velocity.field_1350 + velocity.field_1350 / 3 : 0);
                    player.field_6037 = true;
                    player.field_6017 = fallDistance;

                    if (MoreEnchantingConfig.CONFIG.showDoubleJumpEffect) {
                        player.method_5783(class_3417.field_14706, 1.0F, 1.0F);
                        player.method_51469().method_65096(
                                class_2398.field_11204,
                                player.method_23317(),
                                player.method_23318(),
                                player.method_23321(),
                                10,
                                0.2, 0.1, 0.2, 0.02
                        );
                    }

                    player.getComponent(MoreEnchantingComponents.ENCHANTMENT_DATA_COMPONENT).canDoubleJump = false;
                }
            });
        });
    }
}