/*
 * Decompiled with CFR 0.152.
 */
package shieldbreak.handlers;

import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shieldbreak.handlers.ModConfig;

public class TooltipHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.isCanceled() || !(event.getItemStack().func_77973_b() instanceof ItemShield)) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        float shieldDurability = itemStack.func_77958_k() > 0 ? itemStack.func_77958_k() : ModConfig.server.unbreakableShieldDurability;
        float shieldProtection = Math.max(ModConfig.server.damageMinimumThreshold, Math.min(ModConfig.server.damageMaximumThreshold, shieldDurability / ModConfig.server.damageDurabilityScaling));
        double shieldProtectionRounded = (double)((int)(shieldProtection * 100.0f)) / 100.0;
        event.getToolTip().add(TextFormatting.GREEN + I18n.func_135052_a((String)"tooltip.shieldbreak.shieldingpower", (Object[])new Object[0]) + " " + shieldProtectionRounded + TextFormatting.RESET);
    }
}

