/*
 * Decompiled with CFR 0.152.
 */
package shieldbreak.mixin.vanilla;

import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import shieldbreak.handlers.ModConfig;
import shieldbreak.util.IEntityPlayerMixin;
import shieldbreak.util.PotionEntry;

@Mixin(value={EntityPlayer.class})
public abstract class EntityPlayerMixin
extends EntityLivingBase
implements IEntityPlayerMixin {
    @Unique
    private float shieldbreak$currentAttackDamage = 0.0f;

    @Shadow
    public abstract CooldownTracker func_184811_cZ();

    public EntityPlayerMixin(World worldIn) {
        super(worldIn);
    }

    @Override
    @Unique
    public void shieldbreak$setCurrentDamage(float damage) {
        this.shieldbreak$currentAttackDamage = damage;
    }

    @Overwrite
    protected void func_190629_c(EntityLivingBase attacker) {
        ItemStack playerItem;
        ItemStack itemStack = playerItem = this.func_184587_cr() ? this.func_184607_cu() : ItemStack.field_190927_a;
        if (!(playerItem.func_77973_b() instanceof ItemShield)) {
            return;
        }
        ItemStack attackerItem = attacker.func_184586_b(attacker.func_184600_cs());
        if (!attackerItem.func_190926_b() && attackerItem.func_77973_b().canDisableShield(attackerItem, playerItem, (EntityLivingBase)this, attacker)) {
            float chance = ModConfig.server.shieldBypassChance + (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)attackerItem) * 0.05f;
            if (this.field_70170_p.field_73012_v.nextFloat() < chance) {
                this.func_184811_cZ().func_185145_a(playerItem.func_77973_b(), ModConfig.server.shieldBypassCooldown);
                this.func_184602_cy();
                this.field_70170_p.func_72960_a((Entity)this, (byte)30);
                EntityPlayerMixin.shieldbreak$doShieldPotionEffects(attacker, this, false);
                return;
            }
        }
        int parryTicks = this.func_184612_cw();
        float shieldDurability = playerItem.func_77958_k() > 0 ? playerItem.func_77958_k() : ModConfig.server.unbreakableShieldDurability;
        float shieldProtection = Math.max(ModConfig.server.damageMinimumThreshold, Math.min(ModConfig.server.damageMaximumThreshold, shieldDurability / ModConfig.server.damageDurabilityScaling));
        float knockbackPower = ModConfig.server.knockbackNormal;
        boolean parry = false;
        boolean broken = false;
        if (parryTicks < ModConfig.server.parryTickRange + ModConfig.server.shieldRaiseTickDelay) {
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187767_eL, SoundCategory.PLAYERS, 1.0f, 0.3f);
            knockbackPower = ModConfig.server.knockbackParry;
            parry = true;
        } else if (this.shieldbreak$currentAttackDamage > shieldProtection) {
            this.func_184811_cZ().func_185145_a(playerItem.func_77973_b(), (int)Math.max((float)ModConfig.server.cooldownTicksMinimum, Math.min((float)ModConfig.server.cooldownTicksMaximum, (this.shieldbreak$currentAttackDamage - shieldProtection) * ModConfig.server.cooldownTicksScaling)));
            this.func_184602_cy();
            this.field_70170_p.func_72960_a((Entity)this, (byte)30);
            knockbackPower = ModConfig.server.knockbackBreak;
            broken = true;
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)29);
        }
        attacker.func_70653_a((Entity)this, knockbackPower, this.field_70165_t - attacker.field_70165_t, this.field_70161_v - attacker.field_70161_v);
        if (attacker instanceof EntityPlayerMP) {
            ((EntityPlayerMP)attacker).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)attacker));
        }
        if (parry || broken) {
            EntityPlayerMixin.shieldbreak$doShieldPotionEffects(attacker, this, parry);
        }
        if (ModConfig.server.alwaysResetActiveHand) {
            this.func_184602_cy();
        }
    }

    @Unique
    private static void shieldbreak$doShieldPotionEffects(EntityLivingBase attacker, EntityLivingBase defender, boolean parry) {
        List<PotionEntry> defenderEffect;
        List<PotionEntry> attackerEffect;
        if (parry) {
            attackerEffect = ModConfig.server.getEffectAttackerParry();
            defenderEffect = ModConfig.server.getEffectDefenderParry();
        } else {
            attackerEffect = ModConfig.server.getEffectAttackerBreak();
            defenderEffect = ModConfig.server.getEffectDefenderBreak();
        }
        if (attackerEffect != null) {
            for (PotionEntry entry : attackerEffect) {
                attacker.func_70690_d(new PotionEffect(entry.getPotion(), entry.getDuration(), entry.getAmplifier()));
            }
        }
        if (defenderEffect != null) {
            for (PotionEntry entry : defenderEffect) {
                defender.func_70690_d(new PotionEffect(entry.getPotion(), entry.getDuration(), entry.getAmplifier()));
            }
        }
    }
}

