/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.renderer.RenderUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_9801;

public class OverlayRendererRandomTickableChunks
extends OverlayRendererBase {
    public static final OverlayRendererRandomTickableChunks INSTANCE_FIXED = new OverlayRendererRandomTickableChunks(RendererToggle.OVERLAY_RANDOM_TICKS_FIXED);
    public static final OverlayRendererRandomTickableChunks INSTANCE_PLAYER = new OverlayRendererRandomTickableChunks(RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER);
    private static final class_2350[] HORIZONTALS = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034};
    protected boolean needsUpdate = true;
    @Nullable
    public class_243 newPos;
    protected RendererToggle toggle;
    protected class_243 pos = class_243.field_1353;
    protected double minX;
    protected double minZ;
    protected double maxX;
    protected double maxZ;
    private final HashMap<class_1923, List<class_238>> chunkMap;
    private class_1297 cameraEntity;
    private boolean hasData;

    protected OverlayRendererRandomTickableChunks(RendererToggle toggle) {
        this.toggle = toggle;
        this.useCulling = true;
        this.renderThrough = false;
        this.chunkMap = new HashMap();
        this.cameraEntity = null;
        this.hasData = false;
    }

    @Override
    public String getName() {
        return "RandomTickableChunks";
    }

    public void setNeedsUpdate() {
        this.needsUpdate = true;
    }

    public void setNewPos(@Nullable class_243 pos) {
        this.newPos = pos;
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return this.toggle.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        if (this.needsUpdate) {
            return true;
        }
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED) {
            return this.newPos != null;
        }
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER) {
            return entity.method_23317() != this.pos.field_1352 || entity.method_23321() != this.pos.field_1350;
        }
        return false;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER) {
            this.pos = entity.method_73189();
        } else if (this.newPos != null) {
            this.pos = this.newPos;
            this.newPos = null;
        }
        this.chunkMap.clear();
        Set<class_1923> chunks = this.getRandomTickableChunks(this.pos);
        this.cameraEntity = entity;
        for (class_1923 pos : chunks) {
            ArrayList<class_238> boxes = new ArrayList<class_238>();
            for (class_2350 side : HORIZONTALS) {
                class_238 bb;
                class_1923 posAdj = new class_1923(pos.field_9181 + side.method_10148(), pos.field_9180 + side.method_10165());
                if (chunks.contains(posAdj) || (bb = this.calculateChunkEdge(pos, side, entity.method_73183())) == null) continue;
                boxes.add(bb);
            }
            if (boxes.isEmpty()) continue;
            this.chunkMap.put(pos, boxes);
            this.hasData = true;
        }
        if (this.hasData()) {
            this.render(cameraPos, mc, profiler);
        }
        this.needsUpdate = false;
    }

    @Override
    public boolean hasData() {
        return this.hasData && !this.chunkMap.isEmpty() && this.cameraEntity != null;
    }

    @Override
    public void render(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        this.allocateBuffers();
        this.renderQuads(cameraPos, mc, profiler);
        this.renderOutlines(cameraPos, mc, profiler);
    }

    private void renderQuads(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("random_tick_quads");
        Color4f color = this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER ? Configs.Colors.RANDOM_TICKS_PLAYER_OVERLAY_COLOR.getColor() : Configs.Colors.RANDOM_TICKS_FIXED_OVERLAY_COLOR.getColor();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        class_287 builder = ctx.start(() -> "minihud:random_tick/quads", MaLiLibPipelines.POSITION_COLOR_MASA_LEQUAL_DEPTH_OFFSET_1);
        this.chunkMap.forEach((pos, boxes) -> {
            for (class_238 bb : boxes) {
                RenderUtils.renderWallQuads(bb, cameraPos, color, builder);
            }
        });
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererRandomTickableChunks#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    private void renderOutlines(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("random_tick_outlines");
        Color4f color = this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER ? Configs.Colors.RANDOM_TICKS_PLAYER_OVERLAY_COLOR.getColor() : Configs.Colors.RANDOM_TICKS_FIXED_OVERLAY_COLOR.getColor();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        class_287 builder = ctx.start(() -> "minihud:random_tick/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        this.chunkMap.forEach((pos, boxes) -> {
            for (class_238 bb : boxes) {
                RenderUtils.renderWallOutlines(bb, 16.0, 16.0, true, cameraPos, color, builder);
            }
        });
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererRandomTickableChunks#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    @Override
    public void reset() {
        super.reset();
        this.chunkMap.clear();
        this.cameraEntity = null;
        this.hasData = false;
    }

    protected Set<class_1923> getRandomTickableChunks(class_243 posCenter) {
        HashSet<class_1923> set = new HashSet<class_1923>();
        int centerChunkX = (int)Math.floor(posCenter.field_1352) >> 4;
        int centerChunkZ = (int)Math.floor(posCenter.field_1350) >> 4;
        double maxRange = 16384.0;
        int r = 9;
        for (int cz = centerChunkZ - 9; cz <= centerChunkZ + 9; ++cz) {
            for (int cx = centerChunkX - 9; cx <= centerChunkX + 9; ++cx) {
                double dx = (double)(cx * 16 + 8) - posCenter.field_1352;
                double dz = (double)(cz * 16 + 8) - posCenter.field_1350;
                if (!(dx * dx + dz * dz < 16384.0)) continue;
                set.add(new class_1923(cx, cz));
            }
        }
        if (!set.isEmpty()) {
            this.hasData = true;
        }
        return set;
    }

    @Nullable
    private class_238 calculateChunkEdge(class_1923 pos, class_2350 side, class_1937 world) {
        float maxZ;
        float maxX;
        float minZ;
        float minX;
        switch (side) {
            case field_11043: {
                minX = pos.field_9181 << 4;
                minZ = pos.field_9180 << 4;
                maxX = (float)((double)(pos.field_9181 << 4) + 16.0);
                maxZ = pos.field_9180 << 4;
                break;
            }
            case field_11035: {
                minX = pos.field_9181 << 4;
                minZ = (float)((double)(pos.field_9180 << 4) + 16.0);
                maxX = (float)((double)(pos.field_9181 << 4) + 16.0);
                maxZ = (float)((double)(pos.field_9180 << 4) + 16.0);
                break;
            }
            case field_11039: {
                minX = pos.field_9181 << 4;
                minZ = pos.field_9180 << 4;
                maxX = pos.field_9181 << 4;
                maxZ = (float)((double)(pos.field_9180 << 4) + 16.0);
                break;
            }
            case field_11034: {
                minX = (float)((double)(pos.field_9181 << 4) + 16.0);
                minZ = pos.field_9180 << 4;
                maxX = (float)((double)(pos.field_9181 << 4) + 16.0);
                maxZ = (float)((double)(pos.field_9180 << 4) + 16.0);
                break;
            }
            default: {
                return null;
            }
        }
        int minY = world != null ? world.method_31607() : -64;
        int maxY = world != null ? world.method_31600() + 1 : 320;
        return new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    @Override
    public String getSaveId() {
        return this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED ? "random_tickable_chunks" : "";
    }

    @Override
    @Nullable
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("pos", (JsonElement)JsonUtils.vec3dToJson((class_243)this.pos));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        class_243 pos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"pos");
        if (pos != null && this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED) {
            this.newPos = pos;
        }
    }
}

