/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.Quadrant;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.shapes.ShapeSphereBlocky;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class ShapeSpawnSphere
extends ShapeSphereBlocky {
    protected class_243[] quadrantCenters;
    protected boolean useCornerQuadrants;
    protected double margin = 0.0;

    public ShapeSpawnSphere() {
        this(ShapeType.ADJUSTABLE_SPAWN_SPHERE, Configs.Colors.SHAPE_ADJUSTABLE_SPAWN_SPHERE.getColor(), 24.0);
    }

    public ShapeSpawnSphere(ShapeType shape, Color4f color, double radius) {
        super(shape, color, radius);
        this.updateQuadrantPoints();
    }

    public boolean getUseCornerQuadrants() {
        return this.useCornerQuadrants;
    }

    public void toggleUseCornerQuadrants() {
        this.useCornerQuadrants = !this.useCornerQuadrants;
        this.setNeedsUpdate();
    }

    @Override
    protected void updateEffectiveCenter() {
        super.updateEffectiveCenter();
        this.updateQuadrantPoints();
    }

    private void updateQuadrantPoints() {
        class_243 center = this.getEffectiveCenter();
        if (this.quadrantCenters == null) {
            this.quadrantCenters = new class_243[4];
        }
        this.quadrantCenters[Quadrant.NORTH_WEST.ordinal()] = new class_243(center.field_1352 - this.margin, center.field_1351, center.field_1350 - this.margin);
        this.quadrantCenters[Quadrant.NORTH_EAST.ordinal()] = new class_243(center.field_1352 + this.margin, center.field_1351, center.field_1350 - this.margin);
        this.quadrantCenters[Quadrant.SOUTH_WEST.ordinal()] = new class_243(center.field_1352 - this.margin, center.field_1351, center.field_1350 + this.margin);
        this.quadrantCenters[Quadrant.SOUTH_EAST.ordinal()] = new class_243(center.field_1352 + this.margin, center.field_1351, center.field_1350 + this.margin);
        this.setNeedsUpdate();
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
        this.updateQuadrantPoints();
    }

    @Override
    protected double getTotalRadius() {
        return this.getRadius() + this.margin;
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        lines.add(2, StringUtils.translate((String)"minihud.gui.hover.shape.margin_value", (Object[])new Object[]{ShapeSpawnSphere.d2(this.margin)}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("margin", (JsonElement)new JsonPrimitive((Number)this.margin));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        this.setMargin(JsonUtils.getDouble((JsonObject)obj, (String)"margin"));
    }

    @Override
    protected SphereUtils.RingPositionTest getPositionTest() {
        return this::isPositionOnOrInsideRing;
    }

    protected boolean isPositionOnOrInsideRing(int x, int y, int z, class_2350 outSide) {
        double centerZ;
        double distZ;
        double centerY;
        double distY;
        class_243 effectiveCenter = this.getEffectiveCenter();
        double maxDistSq = this.getSquaredRadius();
        double posX = (double)x + 0.5;
        double posY = y + 1;
        double posZ = (double)z + 0.5;
        if (this.useCornerQuadrants) {
            class_243 quadrantCenter = this.quadrantCenters[Quadrant.getQuadrant((int)x, (int)z, (class_243)effectiveCenter).ordinal()];
            return quadrantCenter.method_1028(posX, posY, posZ) < maxDistSq || effectiveCenter.method_1028(posX, posY, posZ) < maxDistSq;
        }
        double margin = this.margin;
        double centerX = class_3532.method_15350((double)posX, (double)(effectiveCenter.field_1352 - margin), (double)(effectiveCenter.field_1352 + margin));
        double distX = posX - centerX;
        double distSq = distX * distX + (distY = posY - (centerY = effectiveCenter.field_1351)) * distY + (distZ = posZ - (centerZ = class_3532.method_15350((double)posZ, (double)(effectiveCenter.field_1350 - margin), (double)(effectiveCenter.field_1350 + margin)))) * distZ;
        return distSq < maxDistSq;
    }
}

