/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.event;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.interfaces.IWorldLoadListener;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.data.DebugDataManager;
import fi.dy.masa.minihud.data.EntitiesDataManager;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.renderer.OverlayRenderer;
import fi.dy.masa.minihud.renderer.OverlayRendererVillagerInfo;
import fi.dy.masa.minihud.renderer.RenderContainer;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import fi.dy.masa.minihud.util.DataStorage;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class WorldLoadListener
implements IWorldLoadListener {
    public void onWorldLoadPre(@Nullable class_638 worldBefore, @Nullable class_638 worldAfter, class_310 mc) {
        if (worldBefore != null) {
            this.writeDataPerDimension();
            if (worldAfter == null) {
                this.writeDataGlobal();
            }
        }
        if (worldAfter != null) {
            DataStorage.getInstance().onWorldPre();
            HudDataManager.getInstance().onWorldPre();
            EntitiesDataManager.getInstance().onWorldPre();
            DebugDataManager.getInstance().onWorldPre();
        }
    }

    public void onWorldLoadPost(@Nullable class_638 worldBefore, @Nullable class_638 worldAfter, class_310 mc) {
        DataStorage.getInstance().reset(worldAfter == null);
        HudDataManager.getInstance().reset(worldAfter == null);
        EntitiesDataManager.getInstance().reset(worldAfter == null);
        OverlayRendererVillagerInfo.INSTANCE.reset(worldAfter == null);
        DebugDataManager.getInstance().reset(worldAfter == null);
        OverlayRenderer.reset();
        if (worldAfter != null) {
            if (worldBefore == null) {
                this.readStoredDataGlobal();
            }
            this.readStoredDataPerDimension();
            OverlayRenderer.resetRenderTimeout();
            DataStorage.getInstance().onWorldJoin();
            DataStorage.getInstance().setWorldRegistryManager(worldAfter.method_30349());
            HudDataManager.getInstance().onWorldJoin();
            EntitiesDataManager.getInstance().onWorldJoin();
            DebugDataManager.getInstance().onWorldJoin();
        }
    }

    private void writeDataPerDimension() {
        Path file = WorldLoadListener.getCurrentStorageFile(false);
        JsonObject root = new JsonObject();
        root.add("data_storage", (JsonElement)DataStorage.getInstance().toJson());
        root.add("shapes", (JsonElement)ShapeManager.INSTANCE.toJson());
        JsonUtils.writeJsonToFileAsPath((JsonObject)root, (Path)file);
    }

    private void writeDataGlobal() {
        Path file = WorldLoadListener.getCurrentStorageFile(true);
        JsonObject root = new JsonObject();
        root.add("renderers", (JsonElement)RenderContainer.INSTANCE.toJson());
        root.add("hud_data", (JsonElement)HudDataManager.getInstance().toJson());
        JsonUtils.writeJsonToFileAsPath((JsonObject)root, (Path)file);
    }

    private void readStoredDataPerDimension() {
        Path file = WorldLoadListener.getCurrentStorageFile(false);
        JsonElement element = JsonUtils.parseJsonFileAsPath((Path)file);
        if (element != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            if (JsonUtils.hasObject((JsonObject)root, (String)"shapes")) {
                ShapeManager.INSTANCE.fromJson(JsonUtils.getNestedObject((JsonObject)root, (String)"shapes", (boolean)false));
            }
            if (JsonUtils.hasObject((JsonObject)root, (String)"data_storage")) {
                DataStorage.getInstance().fromJson(JsonUtils.getNestedObject((JsonObject)root, (String)"data_storage", (boolean)false));
            }
            if (JsonUtils.hasObject((JsonObject)root, (String)"hud_data")) {
                HudDataManager.getInstance().fromJson(JsonUtils.getNestedObject((JsonObject)root, (String)"hud_data", (boolean)false));
            }
        }
    }

    private void readStoredDataGlobal() {
        Path file = WorldLoadListener.getCurrentStorageFile(true);
        JsonElement element = JsonUtils.parseJsonFileAsPath((Path)file);
        if (element != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            if (JsonUtils.hasObject((JsonObject)root, (String)"renderers")) {
                RenderContainer.INSTANCE.fromJson(JsonUtils.getNestedObject((JsonObject)root, (String)"renderers", (boolean)false));
            }
            if (JsonUtils.hasObject((JsonObject)root, (String)"hud_data")) {
                HudDataManager.getInstance().fromJson(JsonUtils.getNestedObject((JsonObject)root, (String)"hud_data", (boolean)false));
            }
        }
    }

    public static Path getCurrentConfigDirectory() {
        return FileUtils.getConfigDirectoryAsPath().resolve("minihud");
    }

    private static Path getCurrentStorageFile(boolean globalData) {
        Path saveDir = WorldLoadListener.getCurrentConfigDirectory();
        if (!Files.exists(saveDir, new LinkOption[0])) {
            FileUtils.createDirectoriesIfMissing((Path)saveDir);
        }
        if (!Files.isDirectory(saveDir, new LinkOption[0])) {
            MiniHUD.LOGGER.warn("getCurrentStorageFile(): Failed to create the config directory '{}'", (Object)saveDir.toAbsolutePath());
        }
        return saveDir.resolve(StringUtils.getStorageFileName((boolean)globalData, (String)"", (String)".json", (String)"minihud_default"));
    }
}

