/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_631;
import net.minecraft.class_638;

public abstract class BaseBlockRangeOverlay<T extends class_2586>
extends OverlayRendererBase {
    protected final IConfigBoolean renderToggleConfig;
    protected final LongOpenHashSet blockPositions;
    protected final class_2591<T> blockEntityType;
    protected final Class<T> blockEntityClass;
    protected class_1937 world;
    protected boolean needsUpdate;
    protected boolean hasData;
    protected int updateDistance = 48;

    protected BaseBlockRangeOverlay(IConfigBoolean renderToggleConfig, class_2591<T> blockEntityType, Class<T> blockEntityClass) {
        this.renderToggleConfig = renderToggleConfig;
        this.blockEntityType = blockEntityType;
        this.blockEntityClass = blockEntityClass;
        this.blockPositions = new LongOpenHashSet();
        this.world = null;
        this.hasData = false;
    }

    public void setNeedsUpdate() {
        if (!this.renderToggleConfig.getBooleanValue()) {
            this.clear();
            return;
        }
        this.needsUpdate = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBlockStatusChange(class_2338 pos) {
        if (this.renderToggleConfig.getBooleanValue()) {
            LongOpenHashSet longOpenHashSet = this.blockPositions;
            synchronized (longOpenHashSet) {
                this.blockPositions.add(pos.method_10063());
                this.needsUpdate = true;
            }
        }
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return this.renderToggleConfig.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(class_1297 cameraEntity, class_310 mc) {
        return this.needsUpdate || this.lastUpdatePos == null || Math.abs(cameraEntity.method_23317() - (double)this.lastUpdatePos.method_10263()) > (double)this.updateDistance || Math.abs(cameraEntity.method_23321() - (double)this.lastUpdatePos.method_10260()) > (double)this.updateDistance || Math.abs(cameraEntity.method_23318() - (double)this.lastUpdatePos.method_10264()) > (double)this.updateDistance;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null) {
            return;
        }
        this.hasData = this.fetchAllTargetBlockEntityPositions(mc.field_1687, entity.method_24515(), mc);
        this.world = entity.method_37908();
        if (this.hasData()) {
            this.updateBlockRanges(this.world, cameraPos, mc, profiler);
            this.render(cameraPos, mc, profiler);
        }
        this.needsUpdate = false;
    }

    @Override
    public boolean hasData() {
        return this.hasData && !this.blockPositions.isEmpty();
    }

    @Override
    public void render(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        this.renderBlockRange(this.world, cameraPos, mc, profiler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        LongOpenHashSet longOpenHashSet = this.blockPositions;
        synchronized (longOpenHashSet) {
            this.blockPositions.clear();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.resetBlockRange();
        this.clear();
        this.hasData = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fetchAllTargetBlockEntityPositions(class_638 world, class_2338 centerPos, class_310 mc) {
        class_631 chunkManager = world.method_2935();
        int centerCX = centerPos.method_10263() >> 4;
        int centerCZ = centerPos.method_10260() >> 4;
        int chunkRadius = (Integer)mc.field_1690.method_42503().method_41753();
        this.blockPositions.clear();
        for (int cz = centerCZ - chunkRadius; cz <= centerCZ + chunkRadius; ++cz) {
            for (int cx = centerCX - chunkRadius; cx <= centerCX + chunkRadius; ++cx) {
                class_2818 chunk = chunkManager.method_2857(cx, cz, class_2806.field_12803, false);
                if (chunk == null) continue;
                for (class_2586 be : chunk.method_12214().values()) {
                    if (be.method_11017() != this.blockEntityType) continue;
                    LongOpenHashSet longOpenHashSet = this.blockPositions;
                    synchronized (longOpenHashSet) {
                        this.blockPositions.add(be.method_11016().method_10063());
                        this.hasData = true;
                    }
                }
            }
        }
        return !this.blockPositions.isEmpty() && this.blockPositions.size() > 0;
    }

    protected void updateBlockRanges(class_1937 world, class_243 cameraPos, class_310 mc, class_3695 profiler) {
        LongIterator it = this.blockPositions.iterator();
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        double max = ((Integer)mc.field_1690.method_42503().method_41753() + 2) * 16;
        max *= max;
        profiler.method_15396("render_block_ranges");
        while (it.hasNext()) {
            mutablePos.method_16363(it.nextLong());
            class_2586 be = world.method_8321((class_2338)mutablePos);
            if (be == null || !this.blockEntityClass.isAssignableFrom(be.getClass())) {
                it.remove();
                continue;
            }
            double distSq = (cameraPos.field_1352 - (double)mutablePos.method_10263()) * (cameraPos.field_1352 - (double)mutablePos.method_10263()) + (cameraPos.field_1350 - (double)mutablePos.method_10260()) * (cameraPos.field_1350 - (double)mutablePos.method_10260());
            if (distSq > max) continue;
            class_2586 castBe = (class_2586)this.blockEntityClass.cast(be);
            this.updateBlockRange(world, mutablePos.method_10062(), castBe, cameraPos, mc, profiler);
        }
        profiler.method_15407();
    }

    protected abstract void updateBlockRange(class_1937 var1, class_2338 var2, T var3, class_243 var4, class_310 var5, class_3695 var6);

    protected abstract void renderBlockRange(class_1937 var1, class_243 var2, class_310 var3, class_3695 var4);

    protected abstract void resetBlockRange();
}

