package online.connlost.allstackable.mixin;

import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import online.connlost.allstackable.util.IItemMaxCount;
import online.connlost.allstackable.util.ItemsHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1706.class)
public class MixinAnvilScreenHandler {
    /**
    * 
    * Decrement the input stacks by one instead of blindly setting them
    * to an empty stack. The decrement is only done on the server to avoid
    * a desync between the server and client that results in renaming breaking.
    * This prevents entire stacks from being deleted at a time.
    * 
    **/
    @Redirect(method = "onTakeOutput", at = @At(value = "INVOKE", target = "Lnet/minecraft/inventory/Inventory;setStack(ILnet/minecraft/item/ItemStack;)V"))
    private void decrementOne(class_1263 inventory, int slot, class_1799 stack, class_1657 player, class_1799 takenStack) {
        class_1799 originalStack = inventory.method_5438(slot);
        if (ItemsHelper.isModified(originalStack) && originalStack.method_7947() > 1) {
            if(stack.method_7960()) {
                stack = originalStack;
                if (!player.method_37908().field_9236) {
                    stack.method_7934(1);
                }
            }
        }
            
        inventory.method_5447(slot, stack);
    }
    
    /**
    * 
    * Update the output every time the output is taken in addition to
    * updating when the inputs are changed. 
    * This allows the output to be taken multiple times without needing
    * to change an input in between every take.
    * 
    **/
    @Inject(method = "onTakeOutput", at = @At("RETURN"))
    private void updateAfterTaking(CallbackInfo ci) {
        ((class_1706)(Object)this).method_24928();
    }
    
    /**
    * 
    * Only output a single item at a time when the item was originally capped
    * at 1.
    * This prevents entire stacks from being repaired/enchanted at a time with
    * wrong costs. It assumes that if the item was originally stackable, that
    * its anvil costs are already balanced.
    *
    **/
    @ModifyVariable(method = "updateResult", at = @At("STORE"), ordinal = 0)
    private class_1799 copyOne(class_1799 stack) {
        if (ItemsHelper.isModified(stack) && ((IItemMaxCount) stack.method_7909()).getVanillaMaxCount() == 1) { 
            stack = stack.method_7972();
            stack.method_7939(1);
        }
        return stack;
    }
}
