package online.connlost.allstackable.mixin;

import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import online.connlost.allstackable.util.IDispenserBlockEntity;
import online.connlost.allstackable.util.ItemsHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets = "net/minecraft/block/dispenser/DispenserBehavior$15")
public class MixinDispenserBehavior8 {
    @Shadow
    @Final
    private class_2347 fallbackBehavior;

    /**
     * Remove one bucket at a time instead of deleting the entire stack.
     * If there's no room for the empty bucket in the dispenser, have it be
     * dispensed instead.
     * This prevents entire stacks from being deleted at a time.
     **/
    @Inject(
            method = "dispenseSilently",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/item/FluidModificationItem;onEmptied(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;Lnet/minecraft/util/math/BlockPos;)V",
                    shift = At.Shift.AFTER
            ),
            cancellable = true)
    public void dispenseOne(class_2342 pointer, class_1799 stack, CallbackInfoReturnable<class_1799> cir) {
        if (ItemsHelper.isModified(stack) && stack.method_7947() > 1) {
            class_1799 newStack = stack.method_7972();
            newStack.method_7934(1);
//            if (((DispenserBlockEntity) pointer.getBlockEntity()).addToFirstFreeSlot(Items.BUCKET.getDefaultStack()) < 0) {
            if (!((IDispenserBlockEntity) pointer.comp_1970()).tryInsertAndStackItem(class_1802.field_8550.method_7854())) {
                this.fallbackBehavior.dispense(pointer, class_1802.field_8550.method_7854());
            }
//            }
            cir.setReturnValue(newStack);
        }
    }
}
