package online.connlost.allstackable.mixin;

import net.minecraft.class_1799;
import net.minecraft.class_2342;
import online.connlost.allstackable.util.IDispenserBlockEntity;
import online.connlost.allstackable.util.ItemsHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets = "net/minecraft/block/dispenser/DispenserBehavior$9")
public class MixinDispenserBehavior9 {

    @Inject(method = "dispenseSilently", at = @At("HEAD"), cancellable = true)
    public void tryStack(class_2342 pointer, class_1799 stack, CallbackInfoReturnable<class_1799> cir) {
        // Add the item to the first free slot and get the remaining stack
        class_1799 remainingStack = pointer.comp_1970().method_11075(stack);

        // Check if the item is modified and if there's any remaining item stack after the operation
        if (ItemsHelper.isModified(stack) && !remainingStack.method_7960()) {
            // Attempt custom logic to stack the remaining item
            boolean success = ((IDispenserBlockEntity) pointer.comp_1970()).tryInsertAndStackItem(remainingStack);

            // If custom stacking succeeds, cancel further execution and return an empty stack
            if (success) {
                cir.setReturnValue(class_1799.field_8037);
                cir.cancel();
            }
        }
    }
}
