package online.connlost.allstackable.mixin;

import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import online.connlost.allstackable.util.IItemMaxCount;
import online.connlost.allstackable.util.ItemsHelper;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1792.class)
public abstract class MixinItem implements IItemMaxCount {
    @Mutable
    @Final
    @Shadow private class_9323 components;

    @Unique
    private int vanillaMaxCount;

    @Override
    public void revert() {
        setMaxCount(vanillaMaxCount);
    }

    @Override
    public void setMaxCount(int i) {
        class_9323.class_9324 builder = class_9323.method_57827().method_57839(this.components);
        builder.method_57840(class_9334.field_50071, i);
        this.components = builder.method_57838();
    }

    @Override
    public int getVanillaMaxCount() {
        return vanillaMaxCount;
    }

    @Override
    public void setVanillaMaxCount(int vanillaMaxCount) {
        this.vanillaMaxCount = vanillaMaxCount;
    }

    @Inject(method = "<init>", at = @At("RETURN"))
    private void setVanillaMaxCount(class_1792.class_1793 settings, CallbackInfo ci) {
        setVanillaMaxCount((Integer) this.components.method_57830(class_9334.field_50071, ItemsHelper.ItemMaxCount));
    }

    @Inject(method = "getMaxCount", at = @At("HEAD"), cancellable = true)
    private void injectGetMaxCount(CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Integer) this.components.method_57830(class_9334.field_50071, ItemsHelper.ItemMaxCount));
    }

    @Redirect(method = "isEnchantable", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;getMaxCount()I"))
    private int redirectGetMaxCount(class_1799 instance) {
        return ((IItemMaxCount) instance.method_7909()).getVanillaMaxCount();
    }
}
