package online.connlost.allstackable.mixin;

import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2480;
import net.minecraft.class_3222;
import online.connlost.allstackable.server.config.ConfigManager;
import online.connlost.allstackable.util.ItemsHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1799.class)
public class MixinItemStack {

    @Inject(method = "getMaxCount", at = @At("HEAD"), cancellable = true)
    private void preventItemSBoxStack(CallbackInfoReturnable<Integer> cir) {
        if (ConfigManager.getConfigManager().getRuleSetting("stackEmptyShulkerBoxOnly") == 1) {
            class_1799 self = (class_1799) (Object) this;
            if ((self.method_7909() instanceof class_1747) && (((class_1747) self.method_7909()).method_7711() instanceof class_2480)) {
                if (ItemsHelper.shulkerBoxHasItems(self)) {
                    cir.setReturnValue(1);
                }
            }
        }
    }

    @Redirect(method = "damage(ILnet/minecraft/server/world/ServerWorld;Lnet/minecraft/server/network/ServerPlayerEntity;Ljava/util/function/Consumer;)V",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;setDamage(I)V"))
    private void splitStackedTools(class_1799 instance, int damage) {
        class_1799 rest = null;
        if (instance.method_7947() > 1 && ItemsHelper.isModified(instance) && instance.method_27319() != null && instance.method_27319().method_31747()) {
            rest = instance.method_7972();
            rest.method_7934(1);
            instance.method_7939(1);
        }
        instance.method_7974(damage);
        if (rest != null) {
            ItemsHelper.insertNewItem((class_3222) instance.method_27319(), rest);
        }
    }
}
