package online.connlost.allstackable.mixin;

import net.minecraft.class_1799;
import net.minecraft.class_2619;
import online.connlost.allstackable.util.ItemsHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_2619.class)
public class MixinJukeboxBlockEntity {
    
    /**
    * 
    * Only store one record instead of the full stack, since that's what 
    * MusicDiscItem assumes.
    * This prevents item duplication where MusicDiscItem decrements the player's
    * stack by 1, but the Jukebox stores and drops the full stack instead.
    * 
    **/
    @ModifyVariable(method = "setStack", at = @At("HEAD"))
    private class_1799 setStack(class_1799 stack) {
        if (ItemsHelper.isModified(stack) && stack.method_7947() > 1) { 
            stack.method_7939(1);
        }
        return stack;
    }
}
