package online.connlost.allstackable.mixin;

import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import online.connlost.allstackable.util.ItemsHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1792.class)
public class MixinMushroomStewItem {

    @Inject(method = "finishUsing", at = @At("HEAD"), cancellable = true)
    private void stackableStew(class_1799 stack, class_1937 world, class_1309 user, CallbackInfoReturnable<class_1799> cir) {
        // Check if the item is MUSHROOM_STEW
        if (stack.method_7909() == class_1802.field_8208) {
            // Check if the stack is modified and the stack size is greater than or equal to 1
            // >= 1 because it is decreased by 1 before our code execution
            if (ItemsHelper.isModified(stack) && stack.method_7947() >= 1) {
                if (user instanceof class_1657 player) {
                    // Insert a bowl into the player's inventory instead of replacing the stew with a bowl
                    ItemsHelper.insertNewItem(player, new class_1799(class_1802.field_8428));
                }
                // Cancel the original logic and return the current stack (to keep the stew stackable)
                cir.setReturnValue(stack);
            }
        }
    }
}
