package online.connlost.allstackable.mixin;

import online.connlost.allstackable.util.ItemsHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5837;

@Mixin(class_3244.class)
public class MixinServerPlayNetworkHandler {
    @Shadow
    public class_3222 player;

    /**
    *
    * Set the size of the new signed books to the size of the old writable books
    * instead of only making one new signed book regardless of the stack size.
    * This prevents unexpected item deletion.
    *
    **/
    @ModifyVariable(method = "addBook", at = @At("STORE"), ordinal = 1)
    public class_1799 fixSignedBookCount(class_1799 itemStack2, class_5837 title, List<class_5837> pages, int slotId) {
        class_1799 originalStack = player.method_31548().method_5438(slotId);
        if (ItemsHelper.isModified(originalStack)) {
            itemStack2.method_7939(originalStack.method_7947());
        }
        return itemStack2;
    }

    /**
    *
    * Split the written book into several stacks if it is over its maximum
    * stack count. This will occur whenever the writable book stack count is
    * greater than the written book's maximum stack count.
    *
    **/
    @Inject(method = "addBook", at = @At("RETURN"))
    public void fixSignedBookOverCount(class_5837 title, List<class_5837> pages, int slotId, CallbackInfo ci) {
        class_1799 itemStack2 = player.method_31548().method_5438(slotId);
        if (ItemsHelper.isModified(itemStack2) && (itemStack2.method_7947() > itemStack2.method_7914())) {
            class_1799 splitStack = itemStack2.method_7972();
            int count = itemStack2.method_7947() % itemStack2.method_7914();
            splitStack.method_7939(count);
            itemStack2.method_7934(count);
            ItemsHelper.insertNewItem(player, splitStack);
            while(itemStack2.method_7947() > itemStack2.method_7914()) {
                splitStack = itemStack2.method_7972();
                count = itemStack2.method_7914();
                splitStack.method_7939(count);
                itemStack2.method_7934(count);
                ItemsHelper.insertNewItem(player, splitStack);
            }
        }
    }
}
