package online.connlost.allstackable.mixin;

import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1830;
import net.minecraft.class_1937;
import online.connlost.allstackable.util.ItemsHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1830.class)
public class MixinSuspiciousStewItem {

    @Inject(method = "finishUsing", at = @At(value = "HEAD"), cancellable = true)
    private void stackableStew(class_1799 stack, class_1937 world, class_1309 user, CallbackInfoReturnable<class_1799> cir) {
        // >= 1 because it is decreased by 1 before our code execution
        if (ItemsHelper.isModified(stack) && stack.method_7947() >= 1) {
            if (user instanceof class_1657) {
                ItemsHelper.insertNewItem((class_1657)user, new class_1799(class_1802.field_8428));
            }
            cir.setReturnValue(stack);
        }
    }
}

