package online.connlost.allstackable.server.command;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import online.connlost.allstackable.server.config.ConfigManager;
import online.connlost.allstackable.util.ItemsHelper;

import static net.minecraft.class_2170.method_9247;
import static net.minecraft.class_2170.method_9244;

import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2287;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import java.util.LinkedList;

public class StackSizeCommand {

    private static ItemsHelper itemsHelper = ItemsHelper.getItemsHelper();
    private static ConfigManager configManager = ConfigManager.getConfigManager();

    private static int showItem(class_2168 source, class_1792 item) throws CommandSyntaxException {
        source.method_9226(() -> class_2561.method_43469("as.command.show_item",
                class_2561.method_43471(item.method_7876()),
                itemsHelper.getCurrentCount(item),
                itemsHelper.getDefaultCount(item)), false);
        return 1;
    }

    private static int showAll(class_2168 source) throws CommandSyntaxException {
        LinkedList<class_1792> list = itemsHelper.getAllModifiedItems();
        if (list.isEmpty()) {
            source.method_9226(() -> class_2561.method_43471("as.command.show_none"), false);
        }
        for (class_1792 item : list) {
            source.method_9226(() -> class_2561.method_43469("as.command.show_item",
                    class_2561.method_43471(item.method_7876()),
                    itemsHelper.getCurrentCount(item),
                    itemsHelper.getDefaultCount(item)), false);
        }
        return 1;
    }

    private static int showItemOnHand(class_2168 source, class_3222 serverPlayerEntity) throws CommandSyntaxException {
        class_1792 item = null;
        if ((item = getMainHandItem(source, serverPlayerEntity)) == null) {
            return 0;
        }
        return showItem(source, item);
    }

    private static int setItem(class_2168 source, class_1792 item, int count) throws CommandSyntaxException {
        itemsHelper.setSingle(item, count);
        configManager.syncConfig();
        source.method_9226(() -> class_2561.method_43469("as.command.set_item",
                class_2561.method_43471(item.method_7876()),
                count,
                itemsHelper.getDefaultCount(item)), true);
        return 1;
    }

    private static int setItemOnHand(class_2168 source, class_3222 serverPlayerEntity, int count) throws CommandSyntaxException {
        class_1792 item = null;
        if ((item = getMainHandItem(source, serverPlayerEntity)) == null) {
            return 0;
        }
        return setItem(source, item, count);
    }

    private static int setMatched(class_2168 source, String type, int originalSize, int newSize) {
        int count = itemsHelper.setMatchedItems(originalSize, newSize, type);
        configManager.syncConfig();
        source.method_9226(() ->
                class_2561.method_43469(
                        "as.command.set_matched",
                        count,
                        newSize,
                        type.equals("vanilla") ? class_2561.method_43471("as.command.default") : class_2561.method_43471("as.command.previous"),
                        originalSize
                ),
                true
        );
        return 1;
    }

    private static int resetItem(class_2168 source, class_1792 item) throws CommandSyntaxException {
        itemsHelper.resetItem(item);
        configManager.syncConfig();
        source.method_9226(() -> class_2561.method_43469("as.command.reset_item",
                class_2561.method_43471(item.method_7876())), true);
        return 1;
    }

    private static int resetAllItems(class_2168 source) {
        itemsHelper.resetAll(true);
        configManager.resetAllItems();
        source.method_9226(() -> class_2561.method_43471("as.command.reset_all"), true);
        return 1;
    }

    private static int resetItemOnHand(class_2168 source, class_3222 serverPlayerEntity) throws CommandSyntaxException {
        class_1792 item = null;
        if ((item = getMainHandItem(source, serverPlayerEntity)) == null) {
            return 0;
        }
        return resetItem(source, item);
    }

    private static class_1792 getMainHandItem(class_2168 source, class_3222 serverPlayerEntity) throws CommandSyntaxException {
        class_1799 itemStack = serverPlayerEntity.method_6047();
        if (itemStack.method_7960()) {
            String u1 = serverPlayerEntity.method_5477().method_10851().toString();
            String u2 = source.method_9228() instanceof class_3222 ? source.method_9214() : "Server";

            source.method_9213(class_2561.method_43469("as.command.error_empty_hand", u1.equals(u2) ? class_2561.method_43471("as.command.you") : serverPlayerEntity.method_5477()));
            return null;
        }
        return itemStack.method_7909();
    }

    private static int reloadConfig(class_2168 source) {
        configManager.setupConfig();
        source.method_9226(() -> {
            try {
                return class_2561.method_43469("as.command.reloaded", source.method_9207().method_5477());
            } catch (CommandSyntaxException e) {
                return class_2561.method_30163(e.getMessage());
            }
        }, true);
        return 1;
    }

    private static int updateGlobalConfig(class_2168 source, boolean allowAutoApply, boolean updateStackableList) {
        configManager.updateGlobalConfig(updateStackableList, allowAutoApply);
        source.method_9226(() -> class_2561.method_43471("as.command.updated_glob_conf"), true);
        return 1;
    }

    private static int fromGlobal(class_2168 source) {
        configManager.applyGlobalToLocal();
        source.method_9226(() -> class_2561.method_43471("as.command.from_global"), true);
        return 1;
    }

    private static int restore(class_2168 source) {
        if (configManager.restoreBackup()) {
            source.method_9226(() -> class_2561.method_43471("as.command.restored"), true);
            return 1;
        } else {
            source.method_9213(class_2561.method_43471("as.command.nobk"));
            return 0;
        }
    }

    private static int help(class_2168 source) {
        source.method_9226(() -> class_2561.method_43471("as.command.help"), false);
        return 1;
    }

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder<class_2168> literalArgumentBuilder = method_9247("allstackable")
                    .requires(source -> source.method_9259(configManager.getRuleSetting("permissionLevel")))
                    .then(method_9247("help").executes(ctx -> help(ctx.getSource())))
                    .then(method_9247("show")
                            .then(method_9247("hand")
                                    .then(method_9244("targets", class_2186.method_9305())
                                            .executes(ctx -> showItemOnHand(ctx.getSource(), class_2186.method_9315(ctx, "targets"))))
                            )
                            .then(method_9247("all")
                                    .executes(ctx -> showAll(ctx.getSource()))
                            )
                            .then(method_9244("item", class_2287.method_9776(registryAccess))
                                    .executes(ctx -> showItem(ctx.getSource(), class_2287.method_9777(ctx, "item").method_9785()))
                            )

                    )
                    .then(method_9247("reset")
                            .then(method_9247("hand")
                                    .then(method_9244("targets", class_2186.method_9305())
                                            .executes(ctx -> resetItemOnHand(ctx.getSource(), class_2186.method_9315(ctx, "targets"))))
                            )
                            .then(method_9247("all")
                                    .executes(ctx -> resetAllItems(ctx.getSource()))
                            )
                            .then(method_9244("item", class_2287.method_9776(registryAccess))
                                    .executes(ctx -> resetItem(ctx.getSource(), class_2287.method_9777(ctx, "item").method_9785()))
                            )
                    )
                    .then(method_9247("set")
                            .then(method_9244("item", class_2287.method_9776(registryAccess))
                                    .then(method_9244("count", IntegerArgumentType.integer(1, ItemsHelper.ItemMaxCount))
                                            .executes(ctx -> setItem(
                                                    ctx.getSource(),
                                                    class_2287.method_9777(ctx, "item").method_9785(),
                                                    IntegerArgumentType.getInteger(ctx, "count"))))
                            )
                            .then(method_9247("hand")
                                    .then(method_9244("targets", class_2186.method_9305())
                                            .then(method_9244("count", IntegerArgumentType.integer(1, ItemsHelper.ItemMaxCount))
                                                    .executes(ctx -> setItemOnHand(
                                                            ctx.getSource(),
                                                            class_2186.method_9315(ctx, "targets"),
                                                            IntegerArgumentType.getInteger(ctx, "count"))))
                                    )
                            )
                            .then(method_9247("vanilla")
                                    .then(method_9244("vanillaSize", IntegerArgumentType.integer(1, ItemsHelper.ItemMaxCount))
                                            .then(method_9244("customSize", IntegerArgumentType.integer(1, ItemsHelper.ItemMaxCount))
                                                    .executes(ctx -> setMatched(
                                                            ctx.getSource(),
                                                            "vanilla",
                                                            IntegerArgumentType.getInteger(ctx, "vanillaSize"),
                                                            IntegerArgumentType.getInteger(ctx, "customSize")
                                                    ))
                                            )
                                    )
                            )
                            .then(method_9247("modified")
                                    .then(method_9244("previousSize", IntegerArgumentType.integer(1, ItemsHelper.ItemMaxCount))
                                            .then(method_9244("newSize", IntegerArgumentType.integer(1, ItemsHelper.ItemMaxCount))
                                                    .executes(ctx -> setMatched(
                                                            ctx.getSource(),
                                                            "modified",
                                                            IntegerArgumentType.getInteger(ctx, "previousSize"),
                                                            IntegerArgumentType.getInteger(ctx, "newSize")
                                                    ))
                                            )
                                    )
                            )
                            .then(method_9247("all")
                                    .then(method_9244("previousSize", IntegerArgumentType.integer(1, ItemsHelper.ItemMaxCount))
                                            .then(method_9244("newSize", IntegerArgumentType.integer(1, ItemsHelper.ItemMaxCount))
                                                    .executes(ctx -> setMatched(
                                                            ctx.getSource(),
                                                            "all",
                                                            IntegerArgumentType.getInteger(ctx, "previousSize"),
                                                            IntegerArgumentType.getInteger(ctx, "newSize")
                                                    ))
                                            )
                                    )
                            )
                    )
                    .then(method_9247("config")
                            .then(method_9247("reload")
                                    .executes(ctx -> reloadConfig(ctx.getSource()))
                            )
                            .then(method_9247("loadFromGlobal")
                                    .executes(ctx -> fromGlobal(ctx.getSource()))
                            )
                            .then(method_9247("saveToGlobal")
                                    .executes(ctx -> updateGlobalConfig(ctx.getSource(), false, true))
                            )
                            .then(method_9247("globalConfigAutoApply")
                                    .then(method_9247("true").executes(ctx -> updateGlobalConfig(ctx.getSource(), true, false)))
                                    .then(method_9247("false").executes(ctx -> updateGlobalConfig(ctx.getSource(), false, false)))
                            )
                            .then(method_9247("restore")
                                    .executes(ctx -> restore(ctx.getSource()))
                            )

                    );

            dispatcher.register(literalArgumentBuilder);

        });
    }


}
