package online.connlost.allstackable.util;

import java.util.*;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

import static online.connlost.allstackable.AllStackable.LOGGER;

public class ItemsHelper {
    public static final int ItemMaxCount = 99;
    private static ItemsHelper itemsHelper;

    private ItemsHelper() {
    }

    public static ItemsHelper getItemsHelper() {
        if (itemsHelper == null) {
            itemsHelper = new ItemsHelper();
        }
        return itemsHelper;
    }

    public void resetAll(boolean serverSide) {
        for (Map.Entry<class_5321<class_1792>, class_1792> itemEntry : getItemSet()) {
            class_1792 item = itemEntry.getValue();
            ((IItemMaxCount) item).revert();
        }
        if (serverSide) LOGGER.info("[All Stackable] Reset all items");
    }

    public void resetItem(class_1792 item) {
        ((IItemMaxCount) item).revert();
        LOGGER.info("[All Stackable] Reset "+class_7923.field_41178.method_10221(item).toString());
    }

    public void setCountByConfig(Set<Map.Entry<String, Integer>> configSet, boolean serverSide) {
        resetAll(serverSide);
        for (Map.Entry<String, Integer> entry : configSet) {
            class_1792 item = class_7923.field_41178.method_10223(class_2960.method_60654(entry.getKey()));
            int size = Integer.min(entry.getValue(), ItemsHelper.ItemMaxCount);
            if (serverSide)
                LOGGER.info("[All Stackable] Set " + entry.getKey() + " to " + size);
            else
                LOGGER.info("[All Stackable] [Client] Set " + entry.getKey() + " to " + size);
            ((IItemMaxCount) item).setMaxCount(size);

        }
    }

    public int getDefaultCount(class_1792 item) {
        return ((IItemMaxCount) item).getVanillaMaxCount();
    }

    public int getCurrentCount(class_1792 item) {
        return item.method_7882();
    }

    public boolean isVanilla(class_1792 item) {
        return getDefaultCount(item) == getCurrentCount(item);
    }

    public void setSingle(class_1792 item, int count) {
        ((IItemMaxCount) item).setMaxCount(count);
        LOGGER.info("[All Stackable] Set "+class_7923.field_41178.method_10221(item).toString()+" to "+ count);
    }

    public LinkedList<class_1792> getAllModifiedItems() {
        LinkedList<class_1792> list = new LinkedList<>();
        for (Map.Entry<class_5321<class_1792>, class_1792> itemEntry : getItemSet()) {
            class_1792 item = itemEntry.getValue();
            if (getDefaultCount(item) != getCurrentCount(item) && !list.contains(item)) {
                list.add(item);
            }
        }
        return list;
    }

    public int setMatchedItems(int originalSize, int newSize, String type) {
        int counter = 0;
        switch (type) {
            case "vanilla":
                for (Map.Entry<class_5321<class_1792>, class_1792> itemEntry : getItemSet()) {
                    class_1792 item = itemEntry.getValue();
                    if (isVanilla(item) && getCurrentCount(item) == originalSize) {
                        setSingle(item, newSize);
                        counter++;
                    }
                }
                break;
            case "modified":
                for (Map.Entry<class_5321<class_1792>, class_1792> itemEntry : getItemSet()) {
                    class_1792 item = itemEntry.getValue();
                    if (!isVanilla(item) && getCurrentCount(item) == originalSize) {
                        setSingle(item, newSize);
                        counter++;
                    }
                }
                break;
            case "all":
                for (Map.Entry<class_5321<class_1792>, class_1792> itemEntry : getItemSet()) {
                    class_1792 item = itemEntry.getValue();
                    if (getCurrentCount(item) == originalSize) {
                        setSingle(item, newSize);
                        counter++;
                    }
                }
                break;
        }

        return counter;
    }

    public LinkedHashMap<String, Integer> getNewConfigMap() {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<>();
        for (Map.Entry<class_5321<class_1792>, class_1792> itemEntry : getItemSet()) {
            class_1792 item = itemEntry.getValue();
            String id = class_7923.field_41178.method_10221(item).toString();
            if (getDefaultCount(item) != getCurrentCount(item) && !map.containsKey(id)) {
                map.put(id, item.method_7882());
            }
        }
        return map;
    }


    private Set<Map.Entry<class_5321<class_1792>, class_1792>> getItemSet() {
        return class_7923.field_41178.method_29722();
    }


    // From nbt/Tag.java createTag()
    public static final int TAG_END = 0;
    public static final int TAG_BYTE = 1;
    public static final int TAG_SHORT = 2;
    public static final int TAG_INT = 3;
    public static final int TAG_LONG = 4;
    public static final int TAG_FLOAT = 5;
    public static final int TAG_DOUBLE = 6;
    public static final int TAG_BYTEARRAY = 7;
    public static final int TAG_STRING = 8;
    public static final int TAG_LIST = 9;
    public static final int TAG_COMPOUND = 10;
    public static final int TAG_INTARRAY = 11;
    public static final int TAG_LONGARRAY = 12;

    public static boolean shulkerBoxHasItems(class_1799 stack) {
        class_9323 tag = stack.method_57353();

        if (tag == null || !tag.method_57832(class_9334.field_49611))
            return false;

        class_2487 bet = Objects.requireNonNull(tag.method_57829(class_9334.field_49611)).method_57461();
        return bet.method_10573("Items", TAG_LIST) && !bet.method_10554("Items", TAG_COMPOUND).isEmpty();
    }

    public static void insertNewItem(class_1657 player, class_1268 hand, class_1799 stack1, class_1799 stack2) {
        if (stack1.method_7960()) {
            player.method_6122(hand, stack2);
        } else if (!player.method_31548().method_7394(stack2)) {
            player.method_7328(stack2, false);
        }
//        if (player instanceof ServerPlayerEntity) {
//            ((ServerPlayerEntity) player).refreshScreenHandler((ScreenHandler) player.playerScreenHandler);
//        }
    }

    public static void insertNewItem(class_1657 player, class_1799 stack2) {
        if (!player.method_31548().method_7394(stack2)) {
            player.method_7328(stack2, false);
        }
//        if (player instanceof ServerPlayerEntity) {
//            ((ServerPlayerEntity) player).refreshScreenHandler((ScreenHandler) player.playerScreenHandler);
//        }
    }

    public static boolean isModified(class_1799 s) {
        if (s.method_7960()) {
            return false;
        }
        class_1792 i = s.method_7909();
        return ((IItemMaxCount) i).getVanillaMaxCount() != i.method_7882();
    }
}
