/*
 * Decompiled with CFR 0.152.
 */
package xyz.dicedpixels.vwoops;

import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import xyz.dicedpixels.vwoops.config.ConfigManager;
import xyz.dicedpixels.vwoops.config.Configs;

public class Blocks {
    private static final Set<class_2248> holdableBlocks = new HashSet<class_2248>();
    private static Set<class_2248> blocksInTag = new HashSet<class_2248>();
    private static Path worldRoot;

    public static boolean addAllBlocks() {
        boolean result = holdableBlocks.addAll(blocksInTag);
        Blocks.save();
        return result;
    }

    public static boolean addBlock(class_2248 block) {
        boolean result = holdableBlocks.add(block);
        Blocks.save();
        return result;
    }

    public static int compareBlockNames(class_2248 first, class_2248 second) {
        return first.method_9518().getString().compareTo(second.method_9518().getString());
    }

    public static Collection<class_2248> getBlocksInTagSorted() {
        ArrayList<class_2248> list = new ArrayList<class_2248>(blocksInTag);
        list.sort(Blocks::compareBlockNames);
        return list;
    }

    public static Set<class_2248> getHoldableBlocks() {
        return holdableBlocks;
    }

    public static Set<class_2248> getNonHoldableBlocks() {
        return Sets.difference(blocksInTag, holdableBlocks);
    }

    public static void init(Path worldRoot) {
        Blocks.worldRoot = worldRoot;
        holdableBlocks.clear();
        blocksInTag = new HashSet<class_2248>();
        Configs configs = ConfigManager.load(worldRoot);
        for (String id : configs.holdableBlocks) {
            holdableBlocks.add((class_2248)class_7923.field_41175.method_63535(class_2960.method_60654((String)id)));
        }
        for (class_6880 entry : class_7923.field_41175.method_40295()) {
            if (!entry.method_40220(class_3481.field_15460)) continue;
            blocksInTag.add((class_2248)entry.comp_349());
        }
        blocksInTag = Set.copyOf(blocksInTag);
        if (configs.firstRun) {
            holdableBlocks.clear();
            holdableBlocks.addAll(blocksInTag);
            Blocks.save();
        }
    }

    public static boolean removeAllBlocks() {
        if (holdableBlocks.isEmpty()) {
            return false;
        }
        holdableBlocks.clear();
        Blocks.save();
        return true;
    }

    public static boolean removeBlock(class_2248 block) {
        boolean result = holdableBlocks.remove(block);
        Blocks.save();
        return result;
    }

    public static void save() {
        HashSet<String> blockIds = new HashSet<String>();
        for (class_2248 block : holdableBlocks) {
            blockIds.add(class_7923.field_41175.method_10221((Object)block).toString());
        }
        ConfigManager.save(worldRoot, blockIds);
    }

    public static Stream<class_2248> streamHoldableBlocks() {
        return holdableBlocks.stream();
    }

    public static Stream<class_2248> streamNonHoldableBlocks() {
        return Blocks.getNonHoldableBlocks().stream();
    }

    public static void toggleBlock(class_2248 block) {
        if (holdableBlocks.contains(block)) {
            holdableBlocks.remove(block);
        } else {
            holdableBlocks.add(block);
        }
        Blocks.save();
    }
}

