/*
 * Decompiled with CFR 0.152.
 */
package xyz.dicedpixels.vwoops.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import xyz.dicedpixels.vwoops.Vwoops;
import xyz.dicedpixels.vwoops.config.Configs;

public final class ConfigManager {
    private static final String FILE_NAME = "vwoops.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final TypeToken<Set<String>> SET_TYPE = new TypeToken<Set<String>>(){};

    public static Configs load(Path worldRoot) {
        Path path = worldRoot.normalize().resolve(FILE_NAME);
        if (Files.exists(path, new LinkOption[0])) {
            Configs configs;
            block9: {
                BufferedReader reader = Files.newBufferedReader(path);
                try {
                    configs = Configs.of(false, (Set)GSON.fromJson((Reader)reader, SET_TYPE));
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        Vwoops.LOGGER.error("Failed to load configs at '{}'. Using default values.", (Object)path, (Object)exception);
                    }
                }
                reader.close();
            }
            return configs;
        }
        return Configs.empty();
    }

    public static void save(Path worldRoot, Set<String> holdableBlocks) {
        Path path = worldRoot.normalize().resolve(FILE_NAME);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson(holdableBlocks, (Appendable)writer);
        }
        catch (Exception exception) {
            Vwoops.LOGGER.error("Failed to save configs to '{}'.", (Object)path, (Object)exception);
        }
    }
}

