/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.command;

import com.shanebeestudios.hg.api.commandapi.CommandAPI;
import com.shanebeestudios.hg.api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.api.commandapi.arguments.ArgumentSuggestions;
import com.shanebeestudios.hg.api.commandapi.arguments.CustomArgument;
import com.shanebeestudios.hg.api.commandapi.arguments.StringArgument;
import com.shanebeestudios.hg.api.commandapi.exceptions.WrapperCommandSyntaxException;
import com.shanebeestudios.hg.api.commandapi.executors.ExecutionInfo;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.plugin.managers.GameManager;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;

public abstract class CustomArg {
    private static GameManager GAME_MANAGER;
    public static final CustomArg GAME;

    @ApiStatus.Internal
    public static void init(GameManager gameManager) {
        GAME_MANAGER = gameManager;
    }

    public static Game getGame(ExecutionInfo<?, ?> info) throws WrapperCommandSyntaxException {
        Game game = info.args().getByClass("game", Game.class);
        if (game == null) {
            String raw = info.args().getRaw("game");
            throw CommandAPI.failWithString("invalid game '" + raw + "'");
        }
        return game;
    }

    public abstract Argument<?> get(String var1);

    static {
        GAME = new CustomArg(){

            @Override
            public Argument<?> get(String name) {
                return (Argument)new CustomArgument<Game, String>(new StringArgument(name), info -> GAME_MANAGER.getGame(info.input().toLowerCase(Locale.ROOT))).includeSuggestions(ArgumentSuggestions.stringCollectionAsync(info -> CompletableFuture.supplyAsync(GAME_MANAGER::getGameNames)));
            }
        };
    }
}

