/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.shanebeestudios.hg.api.commandapi.CommandAPIBukkit;
import com.shanebeestudios.hg.api.commandapi.CommandAPIHandler;
import com.shanebeestudios.hg.api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.api.commandapi.arguments.CommandAPIArgumentType;
import com.shanebeestudios.hg.api.commandapi.arguments.GreedyArgument;
import com.shanebeestudios.hg.api.commandapi.arguments.PreviewInfo;
import com.shanebeestudios.hg.api.commandapi.arguments.Previewable;
import com.shanebeestudios.hg.api.commandapi.commandsenders.BukkitPlayer;
import com.shanebeestudios.hg.api.commandapi.exceptions.SpigotNotFoundException;
import com.shanebeestudios.hg.api.commandapi.exceptions.WrapperCommandSyntaxException;
import com.shanebeestudios.hg.api.commandapi.executors.CommandArguments;
import com.shanebeestudios.hg.api.commandapi.wrappers.PreviewableFunction;
import java.util.Optional;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatArgument
extends Argument<BaseComponent[]>
implements GreedyArgument,
Previewable<ChatArgument, BaseComponent[]> {
    private PreviewableFunction<BaseComponent[]> preview;
    private boolean usePreview;

    public ChatArgument(String nodeName) {
        super(nodeName, CommandAPIBukkit.get()._ArgumentChat());
        try {
            Class.forName("org.spigotmc.SpigotConfig");
        }
        catch (ClassNotFoundException e) {
            throw new SpigotNotFoundException(this.getClass());
        }
    }

    @Override
    public Class<BaseComponent[]> getPrimitiveType() {
        return BaseComponent[].class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.CHAT;
    }

    @Override
    public <CommandSourceStack> BaseComponent[] parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        CommandSender sender = (CommandSender)CommandAPIBukkit.get().getCommandSenderFromCommandSource(cmdCtx.getSource()).getSource();
        BaseComponent[] component = CommandAPIBukkit.get().getChat(cmdCtx, key);
        Optional<PreviewableFunction<BaseComponent[]>> previewOptional = this.getPreview();
        if (this.usePreview && previewOptional.isPresent() && sender instanceof Player) {
            Player player = (Player)sender;
            try {
                BaseComponent[] previewComponent;
                component = previewComponent = previewOptional.get().generatePreview(new PreviewInfo<BaseComponent[]>(new BukkitPlayer(player), CommandAPIHandler.getRawArgumentInput(cmdCtx, key), cmdCtx.getInput(), component));
            }
            catch (WrapperCommandSyntaxException e) {
                throw e.getException();
            }
        }
        return component;
    }

    @Override
    public ChatArgument withPreview(PreviewableFunction<BaseComponent[]> preview) {
        this.preview = preview;
        return this;
    }

    @Override
    public Optional<PreviewableFunction<BaseComponent[]>> getPreview() {
        return Optional.ofNullable(this.preview);
    }

    @Override
    public boolean isLegacy() {
        return true;
    }

    @Override
    public ChatArgument usePreview(boolean usePreview) {
        this.usePreview = usePreview;
        return this;
    }
}

