/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.commandapi.arguments;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.shanebeestudios.hg.api.commandapi.BukkitTooltip;
import com.shanebeestudios.hg.api.commandapi.CommandAPIBukkit;
import com.shanebeestudios.hg.api.commandapi.CommandAPIHandler;
import com.shanebeestudios.hg.api.commandapi.arguments.Argument;
import com.shanebeestudios.hg.api.commandapi.arguments.CommandAPIArgumentType;
import com.shanebeestudios.hg.api.commandapi.arguments.LiteralArgument;
import com.shanebeestudios.hg.api.commandapi.arguments.MultiLiteralArgument;
import com.shanebeestudios.hg.api.commandapi.executors.CommandArguments;
import java.io.Serializable;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.command.CommandSender;

public class CustomArgument<T, B>
extends Argument<T> {
    private final CustomArgumentInfoParser<T, B> infoParser;
    private final Argument<B> base;
    private static final String INPUT = "%input%";
    private static final String FULL_INPUT = "%finput%";

    public CustomArgument(Argument<B> base, CustomArgumentInfoParser<T, B> parser) {
        super(base.getNodeName(), base.getRawType());
        if (base instanceof LiteralArgument || base instanceof MultiLiteralArgument) {
            throw new IllegalArgumentException(base.getClass().getSimpleName() + " is not a suitable base argument type for a CustomArgument");
        }
        this.base = base;
        this.infoParser = parser;
    }

    @Override
    public Class<T> getPrimitiveType() {
        return null;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.CUSTOM;
    }

    @Override
    public <CommandSourceStack> T parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        String customresult = CommandAPIHandler.getRawArgumentInput(cmdCtx, key);
        Object parsedInput = this.base.parseArgument(cmdCtx, key, previousArgs);
        try {
            return this.infoParser.apply(new CustomArgumentInfo((CommandSender)CommandAPIBukkit.get().getCommandSenderFromCommandSource(cmdCtx.getSource()).getSource(), previousArgs, customresult, parsedInput));
        }
        catch (CustomArgumentException e) {
            throw e.toCommandSyntax(customresult, cmdCtx);
        }
        catch (Exception e) {
            String errorMsg = new MessageBuilder("Error in executing command ").appendFullInput().append(" - ").appendArgInput().appendHere().toString().replace(INPUT, customresult).replace(FULL_INPUT, cmdCtx.getInput());
            throw new SimpleCommandExceptionType(() -> errorMsg).create();
        }
    }

    @FunctionalInterface
    public static interface CustomArgumentInfoParser<T, B> {
        public T apply(CustomArgumentInfo<B> var1) throws CustomArgumentException;
    }

    public record CustomArgumentInfo<B>(CommandSender sender, CommandArguments previousArgs, String input, B currentInput) {
    }

    public static class CustomArgumentException
    extends Exception {
        private BaseComponent[] errorBaseComponent = null;
        private Component errorComponent = null;
        private String errorMessage = null;
        private MessageBuilder errorMessageBuilder = null;

        private CustomArgumentException() {
        }

        @Deprecated(since="9.0.1", forRemoval=true)
        public CustomArgumentException(BaseComponent[] errorMessage) {
            this.errorBaseComponent = errorMessage;
        }

        @Deprecated(since="9.0.1", forRemoval=true)
        public CustomArgumentException(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Deprecated(since="9.0.1", forRemoval=true)
        public CustomArgumentException(MessageBuilder errorMessage) {
            this.errorMessageBuilder = errorMessage;
        }

        public static CustomArgumentException fromBaseComponents(BaseComponent[] errorMessage) {
            CustomArgumentException exception = new CustomArgumentException();
            exception.errorBaseComponent = errorMessage;
            return exception;
        }

        public static CustomArgumentException fromString(String errorMessage) {
            CustomArgumentException exception = new CustomArgumentException();
            exception.errorMessage = errorMessage;
            return exception;
        }

        public static CustomArgumentException fromAdventureComponent(Component errorMessage) {
            CustomArgumentException exception = new CustomArgumentException();
            exception.errorComponent = errorMessage;
            return exception;
        }

        public static CustomArgumentException fromMessageBuilder(MessageBuilder errorMessage) {
            CustomArgumentException exception = new CustomArgumentException();
            exception.errorMessageBuilder = errorMessage;
            return exception;
        }

        public CommandSyntaxException toCommandSyntax(String result, CommandContext<?> cmdCtx) {
            if (this.errorBaseComponent != null) {
                Message brigadierMessage = BukkitTooltip.messageFromBaseComponents(this.errorBaseComponent);
                return new SimpleCommandExceptionType(brigadierMessage).create();
            }
            if (this.errorComponent != null) {
                Message brigadierMessage = BukkitTooltip.messageFromAdventureComponent(this.errorComponent);
                return new SimpleCommandExceptionType(brigadierMessage).create();
            }
            if (this.errorMessageBuilder != null) {
                String errorMsg = this.errorMessageBuilder.toString().replace(CustomArgument.INPUT, result).replace(CustomArgument.FULL_INPUT, cmdCtx.getInput());
                return new SimpleCommandExceptionType((Message)new LiteralMessage(errorMsg)).create();
            }
            if (this.errorMessage != null) {
                return CommandAPIBukkit.get().getPaper().getExceptionFromString(this.errorMessage).getException();
            }
            throw new IllegalStateException("No error component, error message creator or error message specified");
        }
    }

    public static class MessageBuilder
    implements Serializable {
        private static final long serialVersionUID = 838497662821791798L;
        StringBuilder builder;

        public MessageBuilder() {
            this.builder = new StringBuilder();
        }

        public MessageBuilder(String str) {
            this.builder = new StringBuilder(str);
        }

        public MessageBuilder appendArgInput() {
            this.builder.append(CustomArgument.INPUT);
            return this;
        }

        public MessageBuilder appendFullInput() {
            this.builder.append(CustomArgument.FULL_INPUT);
            return this;
        }

        public MessageBuilder appendHere() {
            this.builder.append("<--[HERE]");
            return this;
        }

        public MessageBuilder append(String str) {
            this.builder.append(str);
            return this;
        }

        public MessageBuilder append(Object obj) {
            this.builder.append(obj);
            return this;
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

