/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.shanebeestudios.hg.api.commandapi.CommandAPIBukkit;
import com.shanebeestudios.hg.api.commandapi.arguments.CommandAPIArgumentType;
import com.shanebeestudios.hg.api.commandapi.arguments.LocationType;
import com.shanebeestudios.hg.api.commandapi.arguments.SafeOverrideableArgument;
import com.shanebeestudios.hg.api.commandapi.executors.CommandArguments;
import com.shanebeestudios.hg.api.commandapi.wrappers.Location2D;

public class Location2DArgument
extends SafeOverrideableArgument<Location2D, Location2D> {
    private final boolean isPrecise;

    public Location2DArgument(String nodeName) {
        this(nodeName, LocationType.PRECISE_POSITION);
    }

    public Location2DArgument(String nodeName, LocationType type) {
        this(nodeName, type, true);
    }

    public Location2DArgument(String nodeName, LocationType type, boolean centerPosition) {
        super(nodeName, type == LocationType.BLOCK_POSITION ? CommandAPIBukkit.get()._ArgumentPosition2D() : CommandAPIBukkit.get()._ArgumentVec2(centerPosition), type == LocationType.BLOCK_POSITION ? l -> l.getBlockX() + " " + l.getBlockZ() : l -> l.getX() + " " + l.getZ());
        this.isPrecise = type == LocationType.PRECISE_POSITION;
    }

    public LocationType getLocationType() {
        return this.isPrecise ? LocationType.PRECISE_POSITION : LocationType.BLOCK_POSITION;
    }

    @Override
    public Class<Location2D> getPrimitiveType() {
        return Location2D.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LOCATION_2D;
    }

    @Override
    public <CommandSourceStack> Location2D parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return this.isPrecise ? CommandAPIBukkit.get().getLocation2DPrecise(cmdCtx, key) : CommandAPIBukkit.get().getLocation2DBlock(cmdCtx, key);
    }
}

