/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.data;

import com.google.common.collect.ImmutableMap;
import com.shanebeestudios.hg.api.data.KitEntry;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Language;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class KitData {
    private final Language lang = HungerGames.getPlugin().getLang();
    private final HashMap<String, KitEntry> kitEntries = new HashMap();

    public boolean hasKitPermission(Player player, String kitName) {
        KitEntry kitEntry = this.kitEntries.get(kitName);
        return kitEntry == null || kitEntry.hasKitPermission(player);
    }

    public void giveDefaultKit(Player player) {
        if (this.kitEntries.containsKey("default")) {
            this.setKit(player, "default");
            Util.sendPrefixedMessage((CommandSender)player, this.lang.kits_give_default, new Object[0]);
        }
    }

    public void setKit(Player player, String kitName) {
        if (!this.kitEntries.containsKey(kitName)) {
            Util.sendMessage((CommandSender)player, "<red>" + kitName + this.lang.kits_doesnt_exist, new Object[0]);
            Util.sendMessage((CommandSender)player, "Available Kits:" + this.getKitListString(player), new Object[0]);
        } else {
            this.kitEntries.get(kitName).setInventoryContent(player);
        }
    }

    public String getKitListString(Player player) {
        if (!this.kitEntries.isEmpty()) {
            StringJoiner joiner = new StringJoiner(", ");
            this.kitEntries.forEach((kitName, kitEntry) -> {
                if (kitEntry.hasKitPermission(player)) {
                    joiner.add((CharSequence)kitName);
                }
            });
            return joiner.toString();
        }
        return null;
    }

    public List<String> getKitNameList(@Nullable Player player) {
        ArrayList<String> names = new ArrayList<String>();
        this.kitEntries.forEach((kitName, kitEntry) -> {
            if (player == null || kitEntry.hasKitPermission(player)) {
                names.add((String)kitName);
            }
        });
        return names;
    }

    public ImmutableMap<String, KitEntry> getKitEntries() {
        return ImmutableMap.copyOf(this.kitEntries);
    }

    public KitEntry getKitEntry(String kitName) {
        return this.kitEntries.get(kitName);
    }

    public boolean hasKits() {
        return !this.kitEntries.isEmpty();
    }

    public void addKitEntry(String name, KitEntry kit) {
        this.kitEntries.put(name, kit);
    }

    public void removeKitEntry(String name) {
        this.kitEntries.remove(name);
    }

    public void clearKits() {
        this.kitEntries.clear();
    }
}

