/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.data;

import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Language;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class Leaderboard {
    private final HungerGames plugin;
    private final Language lang;
    private FileConfiguration leaderboardConfig;
    private File config_file;
    private final Map<String, Integer> wins;
    private final Map<String, Integer> kills;
    private final Map<String, Integer> deaths;
    private final Map<String, Integer> gamesPlayed;
    private final List<String> sorted_players_wins;
    private final List<String> sorted_scores_wins;
    private final List<String> sorted_players_kills;
    private final List<String> sorted_scores_kills;
    private final List<String> sorted_players_deaths;
    private final List<String> sorted_scores_deaths;
    private final List<String> sorted_players_gamesPlayed;
    private final List<String> sorted_scores_gamesPlayed;

    public Leaderboard(HungerGames plugin) {
        this.plugin = plugin;
        this.lang = plugin.getLang();
        this.wins = new TreeMap<String, Integer>();
        this.kills = new TreeMap<String, Integer>();
        this.deaths = new TreeMap<String, Integer>();
        this.gamesPlayed = new TreeMap<String, Integer>();
        this.sorted_players_wins = new ArrayList<String>();
        this.sorted_scores_wins = new ArrayList<String>();
        this.sorted_players_kills = new ArrayList<String>();
        this.sorted_scores_kills = new ArrayList<String>();
        this.sorted_players_deaths = new ArrayList<String>();
        this.sorted_scores_deaths = new ArrayList<String>();
        this.sorted_players_gamesPlayed = new ArrayList<String>();
        this.sorted_scores_gamesPlayed = new ArrayList<String>();
        this.loadLeaderboard();
    }

    @Deprecated
    public void addWin(UUID uuid) {
        if (this.wins.containsKey(uuid.toString())) {
            this.wins.replace(uuid.toString(), this.wins.get(uuid.toString()) + 1);
        } else {
            this.wins.put(uuid.toString(), 1);
        }
        this.saveLeaderboard();
    }

    @Deprecated
    public void addWin(Player player) {
        this.addWin(player.getUniqueId());
    }

    @Deprecated
    public int getWins(UUID uuid) {
        return this.wins.get(uuid.toString());
    }

    @Deprecated
    public int getWins(Player player) {
        return this.getWins(player.getUniqueId());
    }

    public void addStat(UUID uuid, Stats stat) {
        this.addStat(uuid, stat, 1);
    }

    public void addStat(UUID uuid, Stats stat, int amount) {
        Map<String, Integer> map = switch (stat.ordinal()) {
            case 1 -> this.kills;
            case 2 -> this.deaths;
            case 3 -> this.gamesPlayed;
            default -> this.wins;
        };
        if (map.containsKey(uuid.toString())) {
            map.replace(uuid.toString(), map.get(uuid.toString()) + amount);
        } else {
            map.put(uuid.toString(), amount);
        }
        this.saveLeaderboard();
    }

    public void addStat(Player player, Stats stat) {
        this.addStat(player, stat, 1);
    }

    public void addStat(Player player, Stats stat, int amount) {
        this.addStat(player.getUniqueId(), stat, amount);
    }

    public int getStat(Player player, Stats stat) {
        return this.getStat(player.getUniqueId(), stat);
    }

    public int getStat(UUID uuid, Stats stat) {
        return (switch (stat.ordinal()) {
            case 1 -> this.kills;
            case 2 -> this.deaths;
            case 3 -> this.gamesPlayed;
            default -> this.wins;
        }).getOrDefault(uuid.toString(), 0);
    }

    public List<String> getStatsPlayers(Stats stat) {
        switch (stat.ordinal()) {
            case 1: {
                return this.sorted_players_kills;
            }
            case 2: {
                return this.sorted_players_deaths;
            }
            case 3: {
                return this.sorted_players_gamesPlayed;
            }
        }
        return this.sorted_players_wins;
    }

    public List<String> getStatsScores(Stats stat) {
        switch (stat.ordinal()) {
            case 1: {
                return this.sorted_scores_kills;
            }
            case 2: {
                return this.sorted_scores_deaths;
            }
            case 3: {
                return this.sorted_scores_gamesPlayed;
            }
        }
        return this.sorted_scores_wins;
    }

    private void saveLeaderboard() {
        this.leaderboardConfig.set("Total-Wins", this.wins);
        this.leaderboardConfig.set("Total-Deaths", this.deaths);
        this.leaderboardConfig.set("Total-Kills", this.kills);
        this.leaderboardConfig.set("Games-Played", this.gamesPlayed);
        try {
            this.leaderboardConfig.save(this.config_file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.sortScores(this.wins, this.sorted_scores_wins, this.sorted_players_wins);
        this.sortScores(this.kills, this.sorted_scores_kills, this.sorted_players_kills);
        this.sortScores(this.deaths, this.sorted_scores_deaths, this.sorted_players_deaths);
        this.sortScores(this.gamesPlayed, this.sorted_scores_gamesPlayed, this.sorted_players_gamesPlayed);
    }

    private void loadLeaderboard() {
        this.config_file = new File(this.plugin.getDataFolder(), "leaderboard.yml");
        if (!this.config_file.exists()) {
            this.plugin.saveResource("leaderboard.yml", true);
        }
        this.leaderboardConfig = YamlConfiguration.loadConfiguration((File)this.config_file);
        this.getLeaderboard("Total-Wins", this.wins, this.sorted_scores_wins, this.sorted_players_wins);
        this.getLeaderboard("Total-Kills", this.kills, this.sorted_scores_kills, this.sorted_players_kills);
        this.getLeaderboard("Total-Deaths", this.deaths, this.sorted_scores_deaths, this.sorted_players_deaths);
        this.getLeaderboard("Games-Played", this.gamesPlayed, this.sorted_scores_gamesPlayed, this.sorted_players_gamesPlayed);
    }

    private void getLeaderboard(String path, Map<String, Integer> map, List<String> scores, List<String> players) {
        if (this.leaderboardConfig.getConfigurationSection(path) != null) {
            for (String key : this.leaderboardConfig.getConfigurationSection(path).getKeys(false)) {
                map.put(key, this.leaderboardConfig.getInt(path + "." + key));
            }
            this.sortScores(map, scores, players);
        }
    }

    private void sortScores(Map<String, Integer> map, List<String> scores, List<String> players) {
        scores.clear();
        players.clear();
        for (Map.Entry entry : Leaderboard.entriesSortedByValues(map)) {
            String player = Bukkit.getOfflinePlayer((UUID)UUID.fromString((String)entry.getKey())).getName();
            int score = (Integer)entry.getValue();
            scores.add(String.valueOf(score));
            players.add(player != null ? player : this.lang.leaderboard_missing_player);
        }
    }

    private static <K, V extends Comparable<? super V>> SortedSet<Map.Entry<K, V>> entriesSortedByValues(Map<K, V> map) {
        TreeSet<Map.Entry<K, V>> sortedEntries = new TreeSet<Map.Entry<K, V>>((e2, e1) -> {
            int res = ((Comparable)e1.getValue()).compareTo(e2.getValue());
            if (res == 0) {
                return 1;
            }
            return res;
        });
        sortedEntries.addAll(map.entrySet());
        return sortedEntries;
    }

    public static enum Stats {
        WINS("wins"),
        KILLS("kills"),
        DEATHS("deaths"),
        GAMES("games");

        private final String stat;

        private Stats(String stat) {
            this.stat = stat;
        }

        public String getName() {
            return this.stat;
        }
    }
}

