/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.data;

import com.shanebeestudios.hg.api.util.NBTApi;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobEntry {
    private final String key;
    private EntityType type;
    private Component name;
    private final Map<EquipmentSlot, ItemStack> gear = new HashMap<EquipmentSlot, ItemStack>();
    private final List<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
    private final Map<Attribute, Double> attributes = new HashMap<Attribute, Double>();
    private String nbt;
    private FixedMetadataValue deathMessageMeta = null;
    private String deathMessage = null;
    private final MythicMob mythicMob;
    private final double mythicLevel;

    public MobEntry(String key, EntityType type) {
        this.key = key;
        this.type = type;
        this.mythicMob = null;
        this.mythicLevel = 0.0;
    }

    public MobEntry(String key, MythicMob mythicMob, double mythicLevel) {
        this.key = key;
        this.mythicLevel = mythicLevel;
        this.mythicMob = mythicMob;
    }

    public String getKey() {
        return this.key;
    }

    @Nullable
    public Component getName() {
        return this.name;
    }

    public void setName(@Nullable Component name) {
        this.name = name;
    }

    public EntityType getType() {
        return this.type;
    }

    public void setType(@NotNull EntityType type) {
        this.type = type;
    }

    public ItemStack getGear(@NotNull EquipmentSlot slot) {
        return this.gear.get(slot);
    }

    public void addGear(@NotNull EquipmentSlot slot, @Nullable ItemStack item) {
        this.gear.put(slot, item);
    }

    public List<PotionEffect> getPotionEffects() {
        return this.potionEffects;
    }

    public void addPotionEffect(PotionEffect potionEffect) {
        this.potionEffects.add(potionEffect);
    }

    public void addPotionEffects(List<PotionEffect> potionEffects) {
        this.potionEffects.addAll(potionEffects);
    }

    public Map<Attribute, Double> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(Attribute attribute, double value) {
        this.attributes.put(attribute, value);
    }

    public String getNbt() {
        return this.nbt;
    }

    public void setNbt(String nbt) {
        this.nbt = nbt;
    }

    @Nullable
    public String getDeathMessage() {
        return this.deathMessage;
    }

    public void setDeathMessage(@Nullable String message) {
        this.deathMessage = message;
        this.deathMessageMeta = new FixedMetadataValue((Plugin)HungerGames.getPlugin(), (Object)message);
    }

    @Nullable
    public Entity spawn(@NotNull Location location) {
        if (this.mythicMob != null) {
            ActiveMob activeMob = this.mythicMob.spawn(BukkitAdapter.adapt((Location)location), this.mythicLevel);
            if (this.deathMessageMeta != null) {
                activeMob.getEntity().getBukkitEntity().setMetadata("death-message", (MetadataValue)this.deathMessageMeta);
            }
            return activeMob.getEntity().getBukkitEntity();
        }
        Class entityClass = this.type.getEntityClass();
        if (entityClass == null) {
            return null;
        }
        return location.getWorld().spawn(location, entityClass, entity -> {
            if (this.name != null) {
                entity.customName(this.name);
                entity.setCustomNameVisible(true);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                EntityEquipment equip = livingEntity.getEquipment();
                if (equip != null) {
                    for (EquipmentSlot slot : EquipmentSlot.values()) {
                        ItemStack gear = this.getGear(slot);
                        if (gear == null) continue;
                        equip.setItem(slot, gear);
                    }
                }
                if (!this.potionEffects.isEmpty()) {
                    for (PotionEffect effect : this.potionEffects) {
                        livingEntity.addPotionEffect(effect);
                    }
                }
                if (!this.attributes.isEmpty()) {
                    this.attributes.forEach((attribute, value) -> {
                        AttributeInstance attributeInstance = livingEntity.getAttribute(attribute);
                        if (attributeInstance != null) {
                            attributeInstance.setBaseValue(value.doubleValue());
                        }
                    });
                }
                if (this.nbt != null) {
                    NBTApi.applyNBTToEntity(entity, this.nbt);
                }
                if (this.deathMessageMeta != null) {
                    livingEntity.setMetadata("death-message", (MetadataValue)this.deathMessageMeta);
                }
            }
        });
    }

    public boolean isMythic() {
        return this.mythicMob != null;
    }

    @Nullable
    public MythicMob getMythicMob() {
        return this.mythicMob;
    }

    public double getMythicLevel() {
        return this.mythicLevel;
    }

    public String toString() {
        if (this.mythicMob != null) {
            return "MobEntry{, mythicMob=" + String.valueOf(this.mythicMob) + ", mythicLevel=" + this.mythicLevel + ", deathMessage='" + this.deathMessage + "'}";
        }
        return "MobEntry{type=" + String.valueOf(this.type) + ", name=" + Util.unMini(this.name) + ", gear=" + String.valueOf(this.gear) + ", potionEffects=" + String.valueOf(this.potionEffects) + ", deathMessage='" + this.deathMessage + "'}";
    }
}

