/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.data;

import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameTeam;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.Nullable;

public class PlayerData
implements Cloneable {
    private static final Scoreboard DUMMY = Bukkit.getScoreboardManager().getNewScoreboard();
    private final ItemStack[] inv;
    private final ItemStack[] equip;
    private final int expL;
    private final float expP;
    private final double health;
    private final int food;
    private final float saturation;
    private final GameMode mode;
    private final UUID uuid;
    private final Scoreboard scoreboard;
    private Location previousLocation = null;
    private boolean online;
    private GameTeam gameTeam;
    private GameTeam pendingGameTeam;
    private final Game game;

    public PlayerData(Player player, Game game) {
        this.game = game;
        this.uuid = player.getUniqueId();
        this.inv = player.getInventory().getStorageContents();
        this.equip = player.getInventory().getArmorContents();
        this.expL = player.getLevel();
        this.expP = player.getExp();
        this.mode = player.getGameMode();
        this.food = player.getFoodLevel();
        this.saturation = player.getSaturation();
        this.health = player.getHealth();
        Util.clearInv(player);
        player.setLevel(0);
        player.setExp(0.0f);
        this.scoreboard = player.getScoreboard();
        this.online = true;
    }

    public void restore(Player player) {
        if (player == null) {
            return;
        }
        Util.clearInv(player);
        player.setWalkSpeed(0.2f);
        player.setLevel(this.expL);
        player.setExp(this.expP);
        player.setFoodLevel(this.food);
        player.setSaturation(this.saturation);
        player.getInventory().setStorageContents(this.inv);
        player.getInventory().setArmorContents(this.equip);
        player.setGameMode(this.mode);
        player.updateInventory();
        player.setInvulnerable(false);
        this.restoreHealth(player);
        player.setWorldBorder(player.getWorld().getWorldBorder());
        player.setScoreboard(DUMMY);
        player.setScoreboard(this.scoreboard);
    }

    private void restoreHealth(Player player) {
        double att = player.getAttribute(Attribute.MAX_HEALTH).getValue();
        if (this.health > att) {
            Bukkit.getScheduler().runTaskLater((Plugin)HungerGames.getPlugin(), () -> player.setHealth(this.health), 10L);
        } else {
            player.setHealth(this.health);
        }
    }

    public boolean isOnTeam(Player player) {
        return this.gameTeam != null && this.gameTeam.isOnTeam(player);
    }

    public Game getGame() {
        return this.game;
    }

    public GameTeam getTeam() {
        return this.gameTeam;
    }

    public void setTeam(GameTeam gameTeam) {
        this.gameTeam = gameTeam;
    }

    public GameTeam getPendingTeam() {
        return this.pendingGameTeam;
    }

    public void setPendingTeam(GameTeam pendingGameTeam) {
        this.pendingGameTeam = pendingGameTeam;
    }

    public GameMode getGameMode() {
        return this.mode;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setPreviousLocation(Location previousLocation) {
        this.previousLocation = previousLocation;
    }

    @Nullable
    public Location getPreviousLocation() {
        if (this.previousLocation != null) {
            return this.previousLocation.clone();
        }
        return null;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOnline(boolean online) {
        this.online = online;
    }

    public Player getBukkitPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public String toString() {
        return "PlayerData{inv=" + Arrays.toString(this.inv) + ", equip=" + Arrays.toString(this.equip) + ", expLevel=" + this.expL + ", expPoints=" + this.expP + ", health=" + this.health + ", food=" + this.food + ", saturation=" + this.saturation + ", mode=" + String.valueOf(this.mode) + ", uuid=" + String.valueOf(this.uuid) + ", team=" + String.valueOf(this.gameTeam) + ", pending=" + String.valueOf(this.pendingGameTeam) + ", game=" + String.valueOf(this.game) + "}";
    }

    public PlayerData clone() {
        try {
            return (PlayerData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

