/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.game;

import com.shanebeestudios.hg.api.game.Data;
import com.shanebeestudios.hg.api.game.Game;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class GameCommandData
extends Data {
    private List<String> commands = null;

    protected GameCommandData(Game game) {
        super(game);
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    public void addCommand(String command, CommandType type) {
        this.commands.add(type.getName() + ":" + command);
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void runCommands(CommandType commandType, @Nullable Player player) {
        if (this.commands == null) {
            return;
        }
        for (String command : this.commands) {
            String type = command.split(":")[0];
            if (!type.equals(commandType.getName()) || command.equalsIgnoreCase("none")) continue;
            command = command.split(":")[1].replace("<world>", this.game.gameArenaData.gameRegion.getWorld().getName()).replace("<arena>", this.game.gameArenaData.getName());
            if (player != null) {
                command = command.replace("<player>", player.getName());
            }
            if (commandType == CommandType.START && command.contains("<player>")) {
                for (Player player1 : this.game.getGamePlayerData().getPlayers()) {
                    String newCommand = command.replace("<player>", player1.getName());
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)newCommand);
                }
                continue;
            }
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        }
    }

    public static enum CommandType {
        DEATH("death"),
        START("start"),
        STOP("stop"),
        JOIN("join");

        final String type;

        private CommandType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.type;
        }
    }
}

