/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.game;

import com.shanebeestudios.hg.api.data.MobData;
import com.shanebeestudios.hg.api.data.MobEntry;
import com.shanebeestudios.hg.api.game.Data;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.plugin.HungerGames;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class GameEntityData
extends Data {
    private static final FixedMetadataValue SPAWN_KEY = new FixedMetadataValue((Plugin)HungerGames.getPlugin(), (Object)true);
    private MobData mobData;
    private final List<Entity> entities = new ArrayList<Entity>();

    GameEntityData(Game game) {
        super(game);
        this.mobData = this.getPlugin().getMobManager().getDefaultMobData();
    }

    public MobData getMobData() {
        return this.mobData;
    }

    public void setMobData(MobData mobData) {
        this.mobData = mobData;
    }

    public boolean spawnMob(Location location, boolean dayTime) {
        Entity spawn;
        MobEntry mobEntry = dayTime ? this.mobData.getRandomDayMob() : this.mobData.getRandomNightMob();
        if (mobEntry != null && (spawn = mobEntry.spawn(location)) != null) {
            this.logEntity(spawn);
            return true;
        }
        return false;
    }

    public void removeEntities() {
        ArrayList<Entity> entitiesToRemove = new ArrayList<Entity>(this.entities);
        entitiesToRemove.forEach(Entity::remove);
        this.entities.clear();
    }

    public void removeEntityFromLog(Entity entity) {
        this.entities.remove(entity);
    }

    public void logEntity(@NotNull Entity entity) {
        if (this.entities.contains(entity)) {
            return;
        }
        entity.setPersistent(false);
        entity.setMetadata("hunger-games-spawned", (MetadataValue)SPAWN_KEY);
        this.entities.add(entity);
    }

    public boolean hasLoggedEntity(Entity entity) {
        return this.entities.contains(entity);
    }

    public List<Entity> getLoggedEntities() {
        return this.entities;
    }

    public int getLoggedEntityCount() {
        return this.entities.size();
    }
}

