/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.game;

import com.shanebeestudios.hg.api.data.KitData;
import com.shanebeestudios.hg.api.data.PlayerData;
import com.shanebeestudios.hg.api.events.PlayerLeaveGameEvent;
import com.shanebeestudios.hg.api.game.Data;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameArenaData;
import com.shanebeestudios.hg.api.game.GameCommandData;
import com.shanebeestudios.hg.api.status.Status;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.managers.GameManager;
import com.shanebeestudios.hg.plugin.managers.PlayerManager;
import com.shanebeestudios.hg.plugin.permission.Permissions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GamePlayerData
extends Data {
    @NotNull
    private static final NamespacedKey JUMP_KEY = NamespacedKey.fromString((String)"hg:freeze_jump");
    @NotNull
    private static final NamespacedKey MOVE_KEY = NamespacedKey.fromString((String)"hg:freeze_move");
    private final PlayerManager playerManager;
    private final GameManager gameManager;
    final List<Player> players = new ArrayList<Player>();
    final List<Player> spectators = new ArrayList<Player>();
    final List<Player> allPlayers = new ArrayList<Player>();
    final Map<Player, Integer> kills = new HashMap<Player, Integer>();
    private final List<Location> randomizedSpawns = new ArrayList<Location>();

    protected GamePlayerData(Game game) {
        super(game);
        this.playerManager = this.plugin.getPlayerManager();
        this.gameManager = this.plugin.getGameManager();
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    void clearPlayers() {
        this.players.clear();
        this.allPlayers.clear();
    }

    public List<Player> getSpectators() {
        return new ArrayList<Player>(this.spectators);
    }

    void clearSpectators() {
        this.spectators.clear();
    }

    private void startMessage(Player player) {
        KitData kitData = this.game.getGameItemData().getKitData();
        for (int i = 0; i < 20; ++i) {
            Util.sendMessage((CommandSender)player, " ", new Object[0]);
        }
        String kitNames = kitData.getKitListString(player);
        Util.sendMessage((CommandSender)player, " ", new Object[0]);
        Util.sendMessage((CommandSender)player, this.lang.kits_join_header, new Object[0]);
        Util.sendMessage((CommandSender)player, " ", new Object[0]);
        if (Permissions.COMMAND_KIT.has((CommandSender)player) && kitData.hasKits()) {
            Util.sendMessage((CommandSender)player, this.lang.kits_join_msg, new Object[0]);
            Util.sendMessage((CommandSender)player, " ", new Object[0]);
            Util.sendMessage((CommandSender)player, this.lang.kits_join_avail + " " + kitNames, new Object[0]);
            Util.sendMessage((CommandSender)player, " ", new Object[0]);
            Util.sendMessage((CommandSender)player, this.lang.kits_join_kits_command, new Object[0]);
            Util.sendMessage((CommandSender)player, " ", new Object[0]);
        }
        Util.sendMessage((CommandSender)player, this.lang.kits_join_footer, new Object[0]);
        Util.sendMessage((CommandSender)player, " ", new Object[0]);
    }

    public void respawnAll() {
        this.randomizedSpawns.clear();
        for (Player player : this.players) {
            player.teleport(this.pickRandomSpawn());
        }
    }

    void heal(Player player) {
        player.clearActivePotionEffects();
        player.closeInventory();
        player.setHealth(20.0);
        player.setFoodLevel(20);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.setFireTicks(0), 1L);
    }

    public void freeze(Player player) {
        player.setGameMode(GameMode.SURVIVAL);
        AttributeInstance movementSpeed = player.getAttribute(Attribute.MOVEMENT_SPEED);
        assert (movementSpeed != null);
        AttributeModifier moveMod = new AttributeModifier(MOVE_KEY, -movementSpeed.getValue(), AttributeModifier.Operation.ADD_NUMBER);
        movementSpeed.addTransientModifier(moveMod);
        AttributeInstance jumpStrength = player.getAttribute(Attribute.JUMP_STRENGTH);
        assert (jumpStrength != null);
        AttributeModifier jumpMod = new AttributeModifier(JUMP_KEY, -jumpStrength.getValue(), AttributeModifier.Operation.ADD_NUMBER);
        jumpStrength.addTransientModifier(jumpMod);
        player.setAllowFlight(false);
        player.setFlying(false);
        player.setInvulnerable(true);
    }

    public void unFreeze(Player player) {
        player.getAttribute(Attribute.MOVEMENT_SPEED).removeModifier((Key)MOVE_KEY);
        player.getAttribute(Attribute.JUMP_STRENGTH).removeModifier((Key)JUMP_KEY);
    }

    public void messageAllActivePlayers(String message) {
        ArrayList<Player> allPlayers = new ArrayList<Player>();
        allPlayers.addAll(this.players);
        allPlayers.addAll(this.spectators);
        for (Player player : allPlayers) {
            Util.sendMessage((CommandSender)player, message, new Object[0]);
        }
    }

    public void messageAllPlayers(String message) {
        ArrayList<Player> allPlayers = new ArrayList<Player>(this.allPlayers);
        allPlayers.addAll(this.spectators);
        for (Player player : allPlayers) {
            Util.sendPrefixedMessage((CommandSender)player, message, new Object[0]);
        }
    }

    private Location pickRandomSpawn() {
        if (this.randomizedSpawns.isEmpty()) {
            this.randomizedSpawns.addAll(this.game.getGameArenaData().getSpawns());
        }
        Collections.shuffle(this.randomizedSpawns);
        Location spawn = this.randomizedSpawns.getFirst();
        this.randomizedSpawns.remove(spawn);
        return spawn;
    }

    void addPlayerData(Player player) {
        this.players.add(player);
        this.allPlayers.add(player);
        this.game.getGameBlockData().updateLobbyBlock();
    }

    void putPlayerIntoArena(Player player, boolean savePreviousLocation) {
        Location loc = this.pickRandomSpawn();
        if (loc.getBlock().getRelative(BlockFace.DOWN).getType() == Material.AIR) {
            while (loc.getBlock().getRelative(BlockFace.DOWN).getType() == Material.AIR) {
                loc.setY(loc.getY() - 1.0);
            }
        }
        if (player.isInsideVehicle()) {
            player.leaveVehicle();
        }
        Location previousLocation = player.getLocation();
        player.teleportAsync(loc).thenAccept(a -> {
            PlayerData playerData = new PlayerData(player, this.game);
            if (savePreviousLocation && Config.savePreviousLocation) {
                playerData.setPreviousLocation(previousLocation);
            }
            this.playerManager.addPlayerData(playerData);
            this.game.getGameScoreboard().setupBoard(player);
            this.heal(player);
            this.freeze(player);
            this.kills.put(player, 0);
            this.startMessage(player);
            this.game.getGameScoreboard().updateBoards();
            this.game.getGameCommandData().runCommands(GameCommandData.CommandType.JOIN, player);
            this.game.getGameItemData().getKitData().giveDefaultKit(player);
        });
    }

    public void addKill(Player player) {
        this.kills.put(player, this.kills.get(player) + 1);
    }

    public void leaveGame(Player player, boolean death) {
        new PlayerLeaveGameEvent(this.game, player, death).callEvent();
        UUID uuid = player.getUniqueId();
        this.players.remove(player);
        if (!death) {
            this.allPlayers.remove(player);
        }
        this.unFreeze(player);
        if (death) {
            if (Config.SPECTATE_ENABLED && Config.spectateOnDeath && !this.game.isGameOver()) {
                this.spectate(player);
                player.playSound(player.getLocation(), Config.SOUNDS_DEATH, 5.0f, 1.0f);
                player.showTitle(this.createTitle());
                this.game.updateAfterDeath(player, true);
                return;
            }
            if (this.game.getGameArenaData().getStatus() == Status.RUNNING) {
                this.game.getGameBarData().removePlayer(player);
            }
        }
        this.heal(player);
        PlayerData playerData = this.playerManager.getPlayerData(uuid);
        assert (playerData != null);
        Location previousLocation = playerData.getPreviousLocation();
        this.game.getGameScoreboard().removePlayerFromSidebar(player);
        playerData.restore(player);
        this.exit(player, previousLocation);
        this.playerManager.removePlayerData(player);
        if (death) {
            player.playSound(player.getLocation(), Config.SOUNDS_DEATH, 5.0f, 1.0f);
        }
        this.game.updateAfterDeath(player, death);
    }

    void exit(Player player, @Nullable Location exitLocation) {
        this.unFreeze(player);
        GameArenaData gameArenaData = this.game.getGameArenaData();
        player.setInvulnerable(false);
        if (gameArenaData.getStatus() == Status.RUNNING) {
            this.game.getGameBarData().removePlayer(player);
        }
        Location location = exitLocation != null ? exitLocation : this.gameManager.getGlobalExitLocation(player);
        PlayerData playerData = this.playerManager.getData(player);
        if (playerData == null || playerData.isOnline()) {
            player.teleportAsync(location);
        } else {
            player.teleport(location);
        }
    }

    public void spectate(Player spectator) {
        UUID uuid = spectator.getUniqueId();
        spectator.teleport(this.game.getGameArenaData().getSpawns().getFirst());
        if (this.playerManager.hasPlayerData(uuid)) {
            this.playerManager.transferPlayerDataToSpectator(uuid);
        } else {
            this.playerManager.addSpectatorData(new PlayerData(spectator, this.game));
        }
        this.spectators.add(spectator);
        spectator.setGameMode(GameMode.SURVIVAL);
        spectator.setCollidable(false);
        if (Config.SPECTATE_FLY) {
            spectator.setAllowFlight(true);
        }
        if (Config.SPECTATE_HIDE) {
            for (Player player : this.players) {
                player.hidePlayer((Plugin)this.plugin, spectator);
            }
            for (Player player : this.spectators) {
                player.hidePlayer((Plugin)this.plugin, spectator);
            }
        }
        this.game.getGameBarData().addPlayer(spectator);
        this.game.getGameScoreboard().setupBoard(spectator);
        spectator.getInventory().setItem(0, this.plugin.getItemManager().getSpectatorCompass());
    }

    public void leaveSpectate(Player spectator) {
        GameMode mode;
        UUID uuid = spectator.getUniqueId();
        PlayerData playerData = this.playerManager.getSpectatorData(uuid);
        if (playerData == null) {
            return;
        }
        Location previousLocation = playerData.getPreviousLocation();
        playerData.restore(spectator);
        this.spectators.remove(spectator);
        spectator.setCollidable(true);
        if (Config.SPECTATE_FLY && ((mode = spectator.getGameMode()) == GameMode.SURVIVAL || mode == GameMode.ADVENTURE)) {
            spectator.setAllowFlight(false);
        }
        if (Config.SPECTATE_HIDE) {
            this.revealPlayer(spectator);
        }
        this.exit(spectator, previousLocation);
        this.playerManager.removeSpectatorData(uuid);
    }

    void revealPlayer(Player hidden) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.showPlayer((Plugin)this.plugin, hidden);
        }
    }

    private Title createTitle() {
        return Title.title((Component)this.game.getGameArenaData().getNameComponent(), (Component)Util.getMini(this.lang.spectate_start_title, new Object[0]), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofMillis(500L)));
    }
}

