/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.game;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameRegion {
    private final BoundingBox boundingBox;
    private final String world;

    public static GameRegion createNew(@NotNull Block corner1, @NotNull Block corner2) {
        BoundingBox boundingBox = BoundingBox.of((Block)corner1, (Block)corner2);
        return new GameRegion(corner1.getWorld().getName(), boundingBox);
    }

    public static GameRegion loadFromConfig(String world, BoundingBox boundingBox) {
        return new GameRegion(world, boundingBox);
    }

    private GameRegion(String world, BoundingBox boundingBox) {
        this.world = world;
        this.boundingBox = boundingBox;
    }

    public Location getRandomLocation() {
        Random random = new Random();
        Location location = new Location(this.getWorld(), (double)random.nextInt((int)this.boundingBox.getWidthX()) + this.boundingBox.getMinX(), this.boundingBox.getMaxY(), (double)random.nextInt((int)this.boundingBox.getWidthZ()) + this.boundingBox.getMinZ());
        return location.getWorld().getHighestBlockAt(location, HeightMap.MOTION_BLOCKING_NO_LEAVES).getLocation().add(0.0, 1.0, 0.0);
    }

    public boolean isInRegion(Location loc) {
        return this.boundingBox.contains(loc.toVector());
    }

    public List<Location> getBlocks(@Nullable Material type) {
        World world = Bukkit.getWorld((String)this.world);
        assert (world != null);
        ArrayList<Location> blockList = new ArrayList<Location>();
        int x = (int)this.boundingBox.getMinX();
        while ((double)x < this.boundingBox.getMaxX()) {
            int y = (int)this.boundingBox.getMinY();
            while ((double)y < this.boundingBox.getMaxY()) {
                int z = (int)this.boundingBox.getMinZ();
                while ((double)z < this.boundingBox.getMaxZ()) {
                    Block block = world.getBlockAt(x, y, z);
                    if (type == null || block.getType() == type) {
                        blockList.add(block.getLocation());
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return blockList;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.world);
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public Location getGreaterCorner() {
        return new Location(this.getWorld(), this.boundingBox.getMaxX(), this.boundingBox.getMaxY(), this.boundingBox.getMaxZ());
    }

    public Location getLesserCorner() {
        return new Location(this.getWorld(), this.boundingBox.getMinX(), this.boundingBox.getMinY(), this.boundingBox.getMinZ());
    }

    public Location getCenter() {
        return new Location(this.getWorld(), this.boundingBox.getCenterX(), this.boundingBox.getCenterY(), this.boundingBox.getCenterZ());
    }

    public String toString() {
        return "Bound{boundingBox=" + String.valueOf(this.boundingBox) + ", world='" + this.world + "'}";
    }
}

