/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.game;

import com.shanebeestudios.hg.api.game.Data;
import com.shanebeestudios.hg.api.game.Game;
import com.shanebeestudios.hg.api.game.GameSidebar;
import com.shanebeestudios.hg.api.game.GameTeam;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.configs.Config;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.Nullable;

public class GameScoreboard
extends Data {
    private final GameSidebar gameSidebar;
    private final Scoreboard scoreboard;
    private final Team baseBukkitTeam;
    final Map<String, GameTeam> gameTeams = new HashMap<String, GameTeam>();

    protected GameScoreboard(Game game) {
        super(game);
        this.gameSidebar = new GameSidebar(game);
        this.scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        this.baseBukkitTeam = this.scoreboard.registerNewTeam("base_team_for_game");
        if (Config.SCOREBOARD_HIDE_NAMETAGS) {
            this.baseBukkitTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        }
        if (Config.SCOREBOARD_SHOW_HEALTH_ENABLED) {
            Objective objective = this.scoreboard.registerNewObjective("health", Criteria.HEALTH, Util.getMini(this.lang.scoreboard_show_health_name, new Object[0]));
            DisplaySlot displaySlot = Config.SCOREBOARD_SHOW_HEALTH_DISPLAY_SLOT.equalsIgnoreCase("below_name") ? DisplaySlot.BELOW_NAME : DisplaySlot.PLAYER_LIST;
            RenderType renderType = Config.SCOREBOARD_SHOW_HEALTH_RENDER_TYPE.equalsIgnoreCase("hearts") ? RenderType.HEARTS : RenderType.INTEGER;
            objective.setDisplaySlot(displaySlot);
            objective.setRenderType(renderType);
        }
    }

    public void setupBoard(Player player) {
        player.setScoreboard(this.scoreboard);
        this.baseBukkitTeam.addPlayer((OfflinePlayer)player);
        this.gameSidebar.setBoard(player);
    }

    public void removePlayerFromSidebar(Player player) {
        this.gameSidebar.removePlayer(player);
    }

    public void updateBoards() {
        this.gameSidebar.updateBoard();
    }

    public void resetSidebars() {
        this.gameSidebar.reset();
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public void createGameTeam(Player player, String teamName) {
        GameTeam gameTeam = new GameTeam(this.game, this, player, teamName);
        this.gameTeams.put(gameTeam.getTeamName(), gameTeam);
        this.updateBoards();
    }

    public void clearGameTeams() {
        this.gameTeams.forEach((team, gameTeam) -> gameTeam.unregister());
        this.gameTeams.clear();
    }

    public boolean hasGameTeam(String teamName) {
        return this.gameTeams.containsKey(teamName);
    }

    public GameTeam getGameTeam(String teamName) {
        return this.gameTeams.get(teamName);
    }

    @Nullable
    public GameTeam getGameTeam(Player player) {
        for (GameTeam gameTeam : this.gameTeams.values()) {
            if (!gameTeam.getPlayers().contains(player)) continue;
            return gameTeam;
        }
        return null;
    }
}

