/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.util;

import com.google.common.collect.ImmutableSet;
import com.shanebeestudios.hg.api.registry.Registries;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.configs.Config;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.tag.TagKey;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.key.Key;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockType;

public class BlockUtils {
    private static ImmutableSet<BlockType> BONUS_BLOCK_TYPES = ImmutableSet.of();
    private static BlockType BONUS_BLOCK_REPLACEMENT_TYPE;
    private static ImmutableSet<BlockType> BREAKABLE_BLOCK_TYPES;
    private static boolean BREAKABLE_BLOCK_ALL;

    public static void setupBuilder() {
        BONUS_BLOCK_TYPES = BlockUtils.setup(Config.CHESTS_BONUS_BLOCK_TYPES).build();
        BONUS_BLOCK_REPLACEMENT_TYPE = BlockUtils.parseBlockType(Config.CHESTS_BONUS_RANDOMIZE_BLOCK);
        if (Config.ROLLBACK_EDITABLE_BLOCKS.contains("all")) {
            BREAKABLE_BLOCK_ALL = true;
        } else {
            BREAKABLE_BLOCK_TYPES = BlockUtils.setup(Config.ROLLBACK_EDITABLE_BLOCKS).build();
        }
    }

    public static ImmutableSet<BlockType> getBonusBlockTypes() {
        return BONUS_BLOCK_TYPES;
    }

    public static boolean isBonusBlock(Block block) {
        Material blockMaterial = block.getType();
        return blockMaterial != Material.CHEST && BONUS_BLOCK_TYPES.contains((Object)blockMaterial.asBlockType());
    }

    public static boolean isBonusBlockReplacement(Block block) {
        if (BONUS_BLOCK_REPLACEMENT_TYPE == null) {
            return false;
        }
        return BONUS_BLOCK_REPLACEMENT_TYPE.equals((Object)block.getType().asBlockType());
    }

    public static boolean isEditableBlock(Material blockMaterial) {
        if (!blockMaterial.isBlock()) {
            return false;
        }
        return BREAKABLE_BLOCK_ALL || BREAKABLE_BLOCK_TYPES.contains((Object)blockMaterial.asBlockType());
    }

    private static ImmutableSet.Builder<BlockType> setup(List<String> blockTypeStrings) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String blockTypeString : blockTypeStrings) {
            if ((blockTypeString = blockTypeString.toLowerCase(Locale.ROOT)).startsWith("#")) {
                NamespacedKey key = NamespacedKey.fromString((String)(blockTypeString = blockTypeString.substring("#".length())));
                if (key != null) {
                    TagKey blockTypeTagKey = TagKey.create((RegistryKey)RegistryKey.BLOCK, (Key)key);
                    if (Registries.BLOCK_TYPE_REGISTRY.hasTag(blockTypeTagKey)) {
                        for (TypedKey blockTypedKey : Registries.BLOCK_TYPE_REGISTRY.getTag(blockTypeTagKey)) {
                            BlockType blockType = (BlockType)Registries.BLOCK_TYPE_REGISTRY.get(blockTypedKey);
                            if (blockType == null) continue;
                            builder.add((Object)blockType);
                        }
                        continue;
                    }
                    Util.warning("Unknown block tag: <red>" + blockTypeString, new Object[0]);
                    continue;
                }
                Util.warning("Unknown block tag: <red>" + blockTypeString, new Object[0]);
                continue;
            }
            BlockType blockType = BlockUtils.parseBlockType(blockTypeString);
            if (blockType == null) continue;
            builder.add((Object)blockType);
        }
        return builder;
    }

    private static BlockType parseBlockType(String blockTypeString) {
        NamespacedKey key = NamespacedKey.fromString((String)blockTypeString);
        if (key != null) {
            BlockType blockType = (BlockType)Registries.BLOCK_TYPE_REGISTRY.get(key);
            if (blockType != null) {
                return blockType;
            }
            Util.warning("Unknown block type: <red>" + blockTypeString, new Object[0]);
        } else {
            Util.warning("Unknown block type: <red>" + blockTypeString, new Object[0]);
        }
        return null;
    }

    static {
        BREAKABLE_BLOCK_TYPES = ImmutableSet.of();
        BREAKABLE_BLOCK_ALL = false;
    }
}

