/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.util;

import com.shanebeestudios.hg.api.util.Constants;
import com.shanebeestudios.hg.api.util.Util;
import com.shanebeestudios.hg.plugin.HungerGames;
import com.shanebeestudios.hg.plugin.configs.Config;
import com.shanebeestudios.hg.plugin.configs.Language;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.ArrayList;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    private static final Language LANG = HungerGames.getPlugin().getLang();

    public static boolean isCursed(ItemStack itemStack) {
        for (Enchantment enchantment : itemStack.getEnchantments().keySet()) {
            if (!enchantment.isCursed()) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getTrackingStick() {
        ItemStack itemStack = ItemType.STICK.createItemStack();
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer pdc = itemMeta.getPersistentDataContainer();
        pdc.set(Constants.TRACKING_STICK_KEY, PersistentDataType.BOOLEAN, (Object)true);
        itemStack.setItemMeta(itemMeta);
        itemStack.setData(DataComponentTypes.ITEM_NAME, (Object)Util.getMini(ItemUtils.LANG.tracking_stick_name, new Object[0]));
        itemStack.setData(DataComponentTypes.MAX_STACK_SIZE, (Object)1);
        itemStack.setData(DataComponentTypes.MAX_DAMAGE, (Object)Config.TRACKING_STICK_USES);
        itemStack.setData(DataComponentTypes.DAMAGE, (Object)0);
        ArrayList lore = new ArrayList();
        ItemUtils.LANG.tracking_stick_lore.forEach(line -> lore.add(Util.getMini(line, new Object[0])));
        itemStack.setData(DataComponentTypes.LORE, (Object)ItemLore.lore(lore));
        return itemStack;
    }

    public static boolean isTrackingStick(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        PersistentDataContainerView pdc = itemStack.getPersistentDataContainer();
        return pdc.has(Constants.TRACKING_STICK_KEY);
    }
}

