/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.hg.api.util;

import com.shanebeestudios.hg.api.nbt.NBT;
import com.shanebeestudios.hg.api.nbt.NBTContainer;
import com.shanebeestudios.hg.api.nbt.NbtApiException;
import com.shanebeestudios.hg.api.nbt.iface.ReadWriteNBT;
import com.shanebeestudios.hg.api.nbt.utils.MinecraftVersion;
import com.shanebeestudios.hg.api.util.HgLogger;
import com.shanebeestudios.hg.api.util.ReflectionUtils;
import com.shanebeestudios.hg.api.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class NBTApi {
    private static boolean ENABLED;
    private static final Class<?> ICHAT_BASE_COMPONENT_CLASS;
    private static final Class<?> CRAFT_CHAT_MESSAGE_CLASS;
    private static final Class<?> TEXT_TAG_VISITOR_CLASS;
    private static final Class<?> NBT_BASE_CLASS;
    private static final Method FROM_COMPONENT;
    private static final Method VISIT_METHOD;
    private static final boolean IS_RUNNING_1_20_5;

    public static void initializeNBTApi() {
        MinecraftVersion.replaceLogger(HgLogger.getLogger());
        if (!NBT.preloadApi()) {
            Util.warning("NBT-API unavailable for your server version.", new Object[0]);
            Util.warning(" - Some items may not be loaded correctly if you are using the 'data' option", new Object[0]);
            ENABLED = false;
        } else {
            ENABLED = true;
        }
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    public static String validateNBT(String nbtString) {
        try {
            NBT.parseNBT(nbtString);
            return null;
        }
        catch (NbtApiException ex) {
            return ex.getMessage();
        }
    }

    public static void applyNBTToItem(ItemStack itemStack, String nbtString) {
        if (!NBTApi.isEnabled()) {
            Util.warning("NBT API is not enabled and cannot apply NBT to item.", new Object[0]);
            return;
        }
        try {
            ReadWriteNBT nbt = NBT.parseNBT(nbtString);
            NBT.modifyComponents(itemStack, itemNbt -> itemNbt.mergeCompound(nbt));
        }
        catch (NbtApiException ex) {
            Util.warning("Invalid NBT '%s'", nbtString);
            Util.warning("Error: %s", ex.getMessage());
        }
    }

    public static void applyNBTToEntity(Entity entity, String nbtString) {
        if (!NBTApi.isEnabled()) {
            Util.warning("NBT API is not enabled and cannot apply NBT to entity.", new Object[0]);
            return;
        }
        try {
            ReadWriteNBT nbt = NBT.parseNBT(nbtString);
            NBT.modify(entity, itemNbt -> itemNbt.mergeCompound(nbt));
        }
        catch (NbtApiException ex) {
            Util.warning("Invalid NBT '%s'", nbtString);
            Util.warning("Error: %s", ex.getMessage());
        }
    }

    @Nullable
    public static String getPrettyNBT(String nbtString, String split) {
        Object nmsNBT = new NBTContainer(nbtString).getCompound();
        String s = split != null ? split : "";
        try {
            Object tagVisitorInstance = IS_RUNNING_1_20_5 ? TEXT_TAG_VISITOR_CLASS.getConstructor(String.class).newInstance(s) : TEXT_TAG_VISITOR_CLASS.getConstructor(String.class, Integer.TYPE).newInstance(s, 0);
            Object prettyComponent = VISIT_METHOD.invoke(tagVisitorInstance, nmsNBT);
            return (String)FROM_COMPONENT.invoke(CRAFT_CHAT_MESSAGE_CLASS, prettyComponent);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        ICHAT_BASE_COMPONENT_CLASS = ReflectionUtils.getNMSClass("net.minecraft.network.chat.IChatBaseComponent");
        CRAFT_CHAT_MESSAGE_CLASS = ReflectionUtils.getOBCClass("util.CraftChatMessage");
        NBT_BASE_CLASS = ReflectionUtils.getNMSClass("net.minecraft.nbt.NBTBase");
        IS_RUNNING_1_20_5 = Util.isRunningMinecraft(1, 20, 5);
        TEXT_TAG_VISITOR_CLASS = ReflectionUtils.getNMSClass("net.minecraft.nbt.TextComponentTagVisitor");
        Method from_comp = null;
        Method visit = null;
        try {
            assert (TEXT_TAG_VISITOR_CLASS != null);
            assert (CRAFT_CHAT_MESSAGE_CLASS != null);
            visit = TEXT_TAG_VISITOR_CLASS.getDeclaredMethod("visit", NBT_BASE_CLASS);
            from_comp = CRAFT_CHAT_MESSAGE_CLASS.getMethod("fromComponent", ICHAT_BASE_COMPONENT_CLASS);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        FROM_COMPONENT = from_comp;
        VISIT_METHOD = visit;
    }
}

